/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SMTPIO_H__
#define __SMTPIO_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*#include <sys/stat.h>*/
/*#include <sys/uio.h>*/
#include <unistd.h>
#include <sys/wait.h>
#include <sys/un.h>
/*#include <sys/param.h>*/
#undef MIN
#undef MAX
#include <glib.h>

#include "defines.h"
#include "parse.h"
#include "sockio.h"
#include "server.h"

/* version information for smtpio */
#define VER_MAJOR '0'
#define VER_MINOR '6'
#define VER_REL   '8'

/* message status's */
#define UNDELIVERED  1
#define DELIVERING   2
#define DELIVERED    3

/* SMTP numerical responses for checking (some smtp servers may not
 * say "250 <user@host.com> Recipient ok..." so we should check for the 
 * numbers that the SMTP server sends back to us instead.) */
#define UnknownCmd     "500"
#define SyntaxErr      "501"
#define CmdNotImpl     "502"
#define BadSeqComs     "503"
#define SysStatRep     "211"
#define HelpInfo       "214"
#define ServiceRdy     "220"
#define ServClose      "221"
#define ServNotAvail   "421"
#define ReqMlActOK     "250"
#define UsrNotLocal    "251"
#define MailboxBusy    "450"
#define ReqNotTaken    "550"
#define ReqAborted     "451"
#define UsrNtLoclTry   "551"
#define InsuffStorage  "452"
#define ExcedStorAlloc "552"
#define MbxNmNotAlwd   "553"
#define StrtMailInpt   "354"
#define TransFailed    "554"

/* Error numbers. */
typedef enum 
{
  S_NO_ERROR,
  S_ERR_RESOLVE,
  S_ERR_SOCKET,
  S_ERR_CONNECT,
  S_ERR_SERV_ACK, 
  S_ERR_HELO_SEND,
  S_ERR_HELO_RECV,
  S_ERR_MAIL_SEND,
  S_ERR_MAIL_RECV, 
  S_ERR_RCPT_SEND,
  S_ERR_RCPT_RECV,
  S_ERR_DATA_SEND,
  S_ERR_DATA_RECV,
  S_ERR_BODY_RECV,
  S_ERR_RSET_SEND,
  S_ERR_RSET_RECV, 
  S_ERR_QUIT_SEND,
  S_ERR_QUIT_RECV,
  S_ERR_INV_SENDR,
  S_ERR_INV_RECIP
} SMTPError;
					  
typedef union 
{
   gchar string[6];
   struct 
   {
      gchar major;
      gchar delim1;
      gchar minor;
      gchar delim2;
      gchar release;
      gchar null;
   } part;
} Version;

typedef struct 
{
   gchar *to, *to_addr;
   gchar *cc, *cc_addr;
   gchar *from, *from_addr;
   gchar *replyto;
   gchar *header;
   gchar *subject;
   gchar *xmailer;
   gchar *mime_version;
   gchar *content_type;
   gchar *content_transfer_encoding;
   gchar *body;
   guint status:2;
} Email;

void smtperror (gchar *reason, gint len);

void email_destroy (Email *msg);

gint format_date (gchar *date, size_t date_size);

gint format_header (Email *msg);

gint get_email_addr_from_text (gchar *addr, gchar *email);

gint helo (gint sock);

gint mail (gint sock, gchar *sender);

gint rcpt (gint sock, gchar *recipient, gchar *orig_rcpt);

gint data (gint sock, gchar *header, gchar *body);

gint rset (gint sock);

gint quit (gint sock);

gint send_message (Server *server, Email *msg);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
