/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "mailbox.h"

static gchar module_path[] = ".spruce/modules";

static gchar mailbox_dir[] = ".spruce";
guint32 *mailpos;

gchar *get_mailbox(gchar *mailbox)
{
   guint memsize;
   gchar *home_dir;
   gchar *buffer;
   gchar *ptr;

   home_dir = g_strdup(getenv("HOME"));
   if (home_dir == NULL)
      return NULL;

   memsize = strlen(home_dir) + 1 + strlen(mailbox_dir) + 1 + strlen(mailbox) + 6;
   buffer = g_malloc0(memsize);
   sprintf(buffer, "%s/%s/%s.mbx", home_dir, mailbox_dir, mailbox);

   /* replace " "'s with "_" so that we can have mailboxes with spaces in the names */
   for (ptr = buffer; *ptr != '\0'; ptr++)
	{
      if (*ptr == ' ')
         *ptr = '_';
	}

   g_free(home_dir);

   return buffer;
}

gboolean mailbox_is_mbox_format(gchar *mbx)
{
   gchar buffer[512];
   FILE *fp;

   fp = fopen(mbx, "rt");
   if (fp == NULL)
      return FALSE;

   memset(buffer, 0, 512);
   fgets(buffer, 511, fp);
   if (!g_strncasecmp("From ", buffer, strlen("From ")))
   {
      fclose(fp);
      return TRUE;
   }

   fclose(fp);

   return FALSE;
}

gint mailbox_make_uid_list(GtkWidget *clistBoxes, guint num)
{
/*   gchar filename[256];
   guint mbox;
   guint mesgid;
   gchar *mesg;
   gchar *mailbox;
   FILE *fp, *tmp;

   g_snprintf(filename, 255, "%s/.spruce/uid.list", getenv("HOME"));
   fp = fopen(filename, "wt");
   if (fp == NULL)
      return 0;

   for (mbox = 0; mbox < num; mbox++)
   {
      
   }
   fclose(fp);*/

   return 1;
}

gint mailbox_append_uid(gchar *uid)
{
   gchar filename[256];
   FILE *fp;

   g_snprintf(filename, 255, "%s/.spruce/uid.list", getenv("HOME"));
   fp = fopen(filename, "at");
   if (fp == NULL)
      return 0;

   trim_whtspc(uid);
   fprintf(fp, "%s\n", uid);
   fflush(fp);
   fclose(fp);

   return 1;
}

gboolean mailbox_have_uid(gchar *uid)
{
   gchar filename[256];
   gchar line[256];
   FILE *fp;

   trim_whtspc(uid);

   g_snprintf(filename, 255, "%s/.spruce/uid.list", getenv("HOME"));
   fp = fopen(filename, "rt");
   if (fp == NULL)
      return FALSE;

   while (!feof(fp))
   {
      memset(line, 0, 255);
      fgets(line, 255, fp);
      trim_whtspc(line);
      if (!strncmp(line, uid, strlen(uid)))
      {
         fclose(fp);
         return TRUE;
      }
   }

   fclose(fp);

   return FALSE;
}

guint mailbox_get_num_mesgs (gchar *mailbox)
{
   gchar *mbx = get_mailbox(mailbox);
   gchar *p, *q;
   struct stat st;
   gint fd;
   guint num = 0;

   if (mbx == NULL)
      return 0;

   fd = open(mbx, O_RDONLY);

   if (mailpos != NULL)
      g_free(mailpos);

   mailpos = g_malloc0(sizeof(guint32));
   mailpos[0] = 0;

   if (fd != -1)
   {
      if (stat(mbx, &st) != -1)
      {
         if (st.st_size)
         {
            p = q = (gchar*) mmap(0, st.st_size, PROT_READ, MAP_PRIVATE, fd, 0);
            if (p == (gchar*)NULL)
            {
               close(fd);
               perror("mmap()");
               return 0;
            }
            while ((p = strstr(p, "\n.\r\n")))
            {
               num++;
               mailpos = g_realloc(mailpos, (num + 1) * sizeof(guint32));
               p += 4;
               mailpos[num] = (guint32)(p - q); /* yuk */
            }
            munmap(q, st.st_size);
         }
      }
      close(fd);
   }

   if (!num)                    /* if there weren't any messages... */
      mailbox_create(mailbox);  /* ...recreate the mailbox */

   g_free(mbx);

   fprintf(stderr, "Total messages for %s = %d\n", mailbox, num);

   return num;
}

gchar *mailbox_get_mesg (guint mesg_num, gchar *mailbox)
{
   gchar *mbx = get_mailbox(mailbox);
   gchar *data = NULL;
   gchar *p, *q;
   struct stat st;
   gint fd;
   guint32 n, offset, pagesize;

   fd = open(mbx, O_RDONLY);

   if (fd != -1)
   {
      if (stat(mbx, &st) != -1)
      {
         pagesize = getpagesize();
         offset = (mailpos[mesg_num - 1] / pagesize) * pagesize;

         p = q = (gchar *)mmap(0, st.st_size, PROT_READ, MAP_PRIVATE, fd, offset);
         if (p == (gchar*)NULL)
         {
            close(fd);
            perror("mmap()");
            return NULL;
         }
         p += mailpos[mesg_num - 1] % pagesize;

         n = (guint32)(strstr(p, "\n.\r\n") - p); /* yuk */

         if (n > 0)
         {
            data = g_malloc0(n + 1);
            strncpy(data, p, n);

            /* we should just strip the message here, makes more sense */
            strip(data, '\r');
         }
         else
            fprintf(stderr, "strstr returned null in mailbox_get_mesg\n");

         munmap(q, st.st_size);
      }
      else
         fprintf(stderr, "Failed to stat %s.\n", mbx);

      close(fd);
   }
   else
     fprintf(stderr, "Failed to open %s.\n", mbx);

   g_free(mbx);

   return data;
}

gchar *mailbox_get_mesg_subject (gchar *message)
{
   gchar buffer[512], ch, *subject;
   int index, i;

   index = find_string(message, "Subject:");
   if (index == -1)
      return NULL;

   /* advance to the start of the subject */
   index += strlen("Subject:") + 1;

   i = 0;
   ch = message[index];
   memset(buffer, 0, sizeof(buffer));
   while(ch != '\r' && ch != '\n')
	{
      buffer[i] = ch;
      index++;
      i++;
      ch = message[index];
	}
   buffer[i] = '\0';

   trim_whtspc(buffer);

   if (buffer[0] != '\0')
      parse_8bit(buffer);

   subject = buffer;

   return subject;
}

gchar *mailbox_get_mesg_from (gchar *message)
{
   gchar buffer[512], ch, *from;
   gint index, i;

   index = find_string(message, "From:");
   if (index == -1)
      return NULL;

   /* advance to the start of From: */
   index += strlen("From:") + 1;

   i = 0;
   ch = message[index];
   memset(buffer, 0, sizeof(buffer));
   while(ch != '\r' && ch != '\n')
	{
      buffer[i] = ch;
      index++;
      i++;
      ch = message[index];
	}
   buffer[i] = '\0';

   trim_whtspc(buffer);

   parse_8bit(buffer);

   from = buffer;

   return from;
}

gchar *mailbox_get_mesg_replyto (gchar *message)
{
   gchar buffer[512], ch, *replyto;
   gint index, i;

   index = find_string(message, "\nReply-To");
   if (index == -1)
      return NULL;

   /* advance to the start of Reply-To: */
   index += strlen("\nReply-To:") + 1;

   i = 0;
   ch = message[index];
   memset(buffer, 0, sizeof(buffer));
   while(ch != '\r' && ch != '\n')
	{
      buffer[i] = ch;
      index++;
      i++;
      ch = message[index];
	}
   buffer[i] = '\0';

   trim_whtspc(buffer);

   replyto = buffer;

   return replyto;
}

gchar *mailbox_get_mesg_date (gchar *message)
{
   gchar buffer[512], ch, *date;
   gint index, i;

   index = find_string(message, "Date:");
   if (index == -1)
      return NULL;

   /* advance to the start of the date */
   index += strlen("Date:") + 1;

   i = 0;
   ch = message[index];
   memset(buffer, 0, sizeof(buffer));
   while(ch != '\r' && ch != '\n')
	{
      buffer[i] = ch;
      index++;
      i++;
      ch = message[index];
	}
   buffer[i] = '\0';

   trim_whtspc(buffer);

   date = buffer;

   return date;
}

gchar *mailbox_get_mesg_xmailer (gchar *message)
{
   gchar buffer[512], ch, *xmailer;
   gint index, i;

   index = find_string(message, "X-Mailer:");
   if (index == -1)
      return NULL;

   /* advance to the start of the xmailer */
   index += strlen("X-Mailer:") + 1;

   i = 0;
   ch = message[index];
   memset(buffer, 0, sizeof(buffer));
   while(ch != '\r' && ch != '\n')
	{
      buffer[i] = ch;
      index++;
      i++;
      ch = message[index];
	}
   buffer[i] = '\0';

   trim_whtspc(buffer);

   xmailer = buffer;

   return xmailer;
}

gchar *mailbox_get_mesg_header_field (gchar *message, gchar *field)
{
   gchar buffer[512], *header, *index, temp_line[512];
   gchar *mesg_header; 
   gint i, done, first;

   /*strip(message, '\r');*/

   /* lets find the end of the header info */
   index = strstr(message,"\n\n");
   if(index == NULL)
	   return (gchar *)NULL;

   index += 2;

   /* now lets make a copy of the header info */
   mesg_header = g_malloc0(index - message + 1);
   strncpy(mesg_header, message, index - message);
   mesg_header[index - message] = '\0';


   index = strstrcase(mesg_header, field);
   if (index == NULL)
      return NULL;

   /* NULL out out buffer */
   memset(buffer, 0, 512);

   /* advance to the start of the header field */
   index += strlen(field) + 1;

   done = 0;
   first = 1;
   /* we'll get data until the first char in the line (except the first line) 
    * is not a tab (indicates a new header field) */
   while (done == 0)
   {
      i = 0;
      while(*index != '\n')
      {
         temp_line[i] = *index;
         i++;
         index++;
      }
      temp_line[i] = '\0';

      if (!first)
      {
         if (temp_line[0] != '\t' && temp_line[0] != ' ')
         done = 1;
      }
			
      if(!done)
      {
         strcat(buffer, temp_line);
         index++;
         first = 0;
      }
   }

   trim_whtspc(buffer);

   if (!strcmp(field, "Subject:") || !strcmp(field, "From:"))
      parse_8bit(buffer);

   header = buffer;

   g_free(mesg_header);

   return header;
}

/* Must sort messages BEFORE calling this function */
gint mailbox_del_mesgs (guint mesgs, guint *mesg_num, gchar *mailbox)
{
   /* delete the specified message(s) by first copying the entire mailbox
    * to a temp file (except the message to be deleted) and then copying
    * it back. */
   gchar *mbx = get_mailbox(mailbox);
   gchar *tmbx = get_mailbox("_TempDel_");
   FILE *fp, *tfp;
   gchar line[513];
   gint num = 1, last_was_end, i = 0;

   if (mesg_num <= 0)
      return 0;

   fp = fopen(mbx, "rt");
   if (fp == NULL)
      return 0;

   tfp = fopen(tmbx, "wt");
   if (tfp == NULL)
      return 0;
   chmod(tmbx, S_IREAD | S_IWRITE);

   while (i < mesgs)
	{
      /* get all the messages up to the one to be deleted */
      while(num < mesg_num[i])
      {
         fgets(line, 512, fp);
         fprintf(tfp, "%s", line);
         if(!strcmp(line, ".\r\n"))
            num++;
      }

      /* skip this next message (one to be deleted) */
      while(num == mesg_num[i])
	   {
         fgets(line, 512, fp);
         if (!strcmp(line, ".\r\n"))
            num++;
	   }
      i++;
   }

   /* get the rest... */
   last_was_end = 1;
   while(!feof(fp))
	{
      fgets(line, 512, fp);
      if (last_was_end && !strcmp(line, ".\r\n"))
         continue;
      fprintf(tfp, "%s", line);
      if (!strcmp(line, ".\r\n"))
         last_was_end = 1;
      else
         last_was_end = 0;
	}

   fflush(fp);
   fflush(tfp);

   fclose(fp);  /* close the file */
   fclose(tfp);

   /* new method...maybe this'll make it faster */
   rename(tmbx, mbx);

   g_free(mbx);
   g_free(tmbx);

   return 1;
}

/* Must sort messages BEFORE calling this function */
gint mailbox_copy_mesgs(guint mesgs, guint *mesg_num, gchar *orig_mailbox, gchar *new_mailbox)
{
   gchar *mesg;
   gchar *newmbx = get_mailbox(new_mailbox);
   FILE *fp;
   guint i = 0;

   fp = fopen(newmbx, "at");
   if (fp == NULL)
	   return 0;

   while(i < mesgs)
   {
      mesg = mailbox_get_mesg(mesg_num[i], orig_mailbox);
      if (mesg == NULL)
         return 0;
      fprintf(fp, "%s\n.\r\n", mesg);
      g_free(mesg);
      i++;
   }

   fflush(fp);
   fclose(fp);

   g_free(newmbx);

   return 1;
}

/* Must sort messages BEFORE calling this function */
gint mailbox_move_mesgs(guint mesgs, guint *mesg_num, gchar *orig_mailbox, gchar *new_mailbox)
{
   if (!mailbox_copy_mesgs(mesgs, mesg_num, orig_mailbox, new_mailbox))
      return 0;
   if (!mailbox_del_mesgs(mesgs, mesg_num, orig_mailbox))
      return 0;

   return 1;
}

gint mailbox_delete(gchar *mailbox)
{
   /* delete the mailbox */
   gchar *mbx = get_mailbox(mailbox);

   remove(mbx);

   g_free(mbx);

   return 1;
}

gint mailbox_create(gchar *mailbox)
{
   /* create a new mailbox or at least clean it out. */
   gchar *mbx = get_mailbox(mailbox);
   gint fd;

   fd = open(mbx, O_WRONLY | O_TRUNC | O_CREAT, 00600);
   if (fd == -1)
   {
      g_free(mbx);
      return 0;
   }

   close(fd);

   g_free(mbx);

   return 1;
}

gint get_header_len(gchar *mesg)
{
   gchar *start;

   /* advance to the point where there are at least 2x end-lines
    * which should mark the end of the header info and the beginning
    * of the body of the message. */
   for (start = mesg; *start != '\0'; start++)
      if (*start == '\n' && *(start - 1) == '\n')
         break;

   return (start - mesg);
}

gchar *get_trimmed_header(gchar *mesg, gint trim_level, gint hdrlen)
{
   gchar *hdrinfo, *hdrstripped;
   gchar *hdrptr, *fieldptr;
   gchar showfields[6][16] = { "Date:", "\nTo:", "\nFrom:", "\nReply-To:", "\nSubject:", "\0" };
   gint  i;

   hdrinfo = g_malloc0(hdrlen + 1);
   strncpy(hdrinfo, mesg, hdrlen);
   if (trim_level == 2)
      return hdrinfo;

   hdrstripped = g_malloc0(hdrlen + 1);
   i = 0;
   hdrptr = hdrstripped;
   while (*showfields[i] != '\0')
   {
      if ((fieldptr = strstrcase(hdrinfo, showfields[i])) != NULL)
      {
         *hdrptr = *fieldptr;
         hdrptr++;
         fieldptr++;
         for ( ; *fieldptr != '\n' && *fieldptr != '\0'; hdrptr++, fieldptr++)
            *hdrptr = *fieldptr;
         *hdrptr = '\n';
      }
      i++;
   }
   *hdrptr = '\0';
   g_free(hdrinfo);
   hdrinfo = g_strdup(hdrstripped);
   g_free(hdrstripped);

   return(hdrinfo);
}

void trim_header(gchar *mesg, gint trim_level)
{
   gchar *start, *ptr, *ptr_mesg;
   gchar *hdrstripped;
   gint  hdrlen;

   /*strip(mesg, '\r');*/

   start = mesg;
   hdrlen = get_header_len(mesg);
   if (trim_level != 2)
      start += hdrlen;

   if (trim_level == 1)			/* show partial header only */
   {
      hdrstripped = get_trimmed_header(mesg, trim_level, hdrlen);
      start -= strlen(hdrstripped);
      strncpy(start, hdrstripped, strlen(hdrstripped));
      g_free(hdrstripped);
   }

   /* advance to the actual beginning of the message (gets rid of any
    * extra line feeds that might be between the header and the actual
    * message). */
   for ( ; *start != '\0'; start++)
      if (*start != '\n')
         break;

   for (ptr_mesg = mesg, ptr = start; *ptr != '\0'; ptr_mesg++, ptr++)
      *ptr_mesg = *ptr;

   *ptr_mesg = '\0';
}

/* please update me to handle multiple ids */
void mailbox_refresh_mailpos (guint num_ids, guint *ids, guint num_mesgs, gchar *mailbox)
{
   /* num_ids   = number of ids */
   /* ids       = message id of the message we deleted  (1 thru x) */
   /* num_mesgs = number of messages after we deleted 1 */
   /* mailbox = we're gonna try to do away with this var, but until I work
      out the bug in the code before mailbox_get_num_mesgs() we're gonna
      have to keep it around as our failsafe */
   guint32 mesg_size;
   guint i, mesgid;

   /* if we have messages left and we didn't just delete the last message... */
   if (num_mesgs > 0 && ids[0] != (num_mesgs + 1) )
   {
      mesgid = ids[0] - 1;                            /* set the mesg id to the array id */
      mesg_size = mailpos[ids[0]] - mailpos[mesgid];  /* calc deleted mesg size */
/*      fprintf(stderr, "mesg_size = %d\n", mesg_size);
		fflush(stderr);*/

      /* mailpos[mesgid] stays the same byte offset */

      for (i = mesgid; i < num_mesgs - ids[0]; i++)
         mailpos[i] = mailpos[i + 1] - mesg_size;
   }

   mailbox_get_num_mesgs(mailbox);  /* temp fix cuz thus function bombs */
}
