/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#   include "config.h"
#endif

#include <gtk/gtk.h>
#include "gti.h"

void gti (GtkText *text, GdkFont *font, GdkColor *fg, 
                        GdkColor *bg, const gchar *chars, gint length)
{
#ifndef BROKEN_GTK_TEXT_INSERT
   if (chars == (gchar*)NULL)
      return;

   gtk_text_insert(text, font, fg, bg, chars, length);
#else
   GtkStyle *style1, *style2;

   if (chars == (gchar*)NULL)
      return;

   style1 = gtk_widget_get_style(GTK_WIDGET(text));
   style2 = gtk_style_copy(style1);
   style2->font = font;
   gtk_widget_set_style(GTK_WIDGET(text), style2);
   gtk_style_unref(style2);
   gtk_text_insert(text, NULL, fg, bg, chars, length);
#endif
} 

