/*
 * ratCompat.c --
 *
 *	This file contains compatibility functions.
 *
 * TkRat software and its included text is Copyright 1996,1997,1998
 * by Martin Forssn
 *
 * Postilion software and its included text and images
 * Copyright (C) 1998 Nic Bernstein
 *
 * The full text of the legal notices is contained in the files called
 * COPYING and COPYRIGHT.TkRat, included with this distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "rat.h"

#if TCL_MAJOR_VERSION < 8


/*
 *----------------------------------------------------------------------
 *
 * RatFile --
 *
 *      An implementation of the file command which emulates the 8.0
 *	behaviour.
 *
 * Results:
 *	A standard tcl result
 *
 * Side effects:
 *	May modify the file system
 *
 *
 *----------------------------------------------------------------------
 */

int
RatFile(ClientData dummy, Tcl_Interp *interp, int argc, char *argv[])
{
    Tcl_CmdInfo info;
    int i;

    if (argc > 3 && !strcmp("copy", argv[1])) {
	int force = 0;
	Tcl_DString ds;
	for (i=2; i<argc && '-' == argv[i][0]; i++) {
	    if (!strcmp("-force", argv[i])) {
		force = 1;
	    } else if (!strcmp("--", argv[i])) {
		i++;
		break;
	    } else {
		Tcl_SetResult(interp, "Invalid argument", TCL_STATIC);
		return TCL_ERROR;
	    }
	}
	if (i != argc-2) {
	    Tcl_SetResult(interp, "You can only give two filenames",TCL_STATIC);
	    return TCL_ERROR;
	}
	Tcl_DStringInit(&ds);
	Tcl_DStringAppend(&ds, "cp ", 3);
	if (force) {
	    Tcl_DStringAppend(&ds, "-f ", 3);
	}
	Tcl_DStringAppend(&ds, argv[i], -1);
	Tcl_DStringAppend(&ds, " ", 1);
	Tcl_DStringAppend(&ds, argv[i+1], -1);
	system(Tcl_DStringValue(&ds));
	Tcl_DStringFree(&ds);
	return TCL_OK;

    } else if (argc > 2 && !strcmp("delete", argv[1])) {
	for (i=2; i<argc && '-' == argv[i][0]; i++) {
	    if (!strcmp("-force", argv[i])) {
		continue;
	    } else if (!strcmp("--", argv[i])) {
		i++;
		break;
	    } else {
		Tcl_SetResult(interp, "Invalid argument", TCL_STATIC);
		return TCL_ERROR;
	    }
	}
	for(; i<argc; i++) {
	    unlink(argv[i]);
	}
	return TCL_OK;

    } else {
	Tcl_GetCommandInfo(interp, "RatOldFile", &info);
	return (*info.proc)(info.clientData, interp, argc, argv);
    }
}

#endif	/* TCL_MAJOR_VERSION < 8 */
