/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#ifndef	token_h
#define	token_h

static const char token_h_rcsid[]="$Id: token.h 1.7 1999/08/02 05:02:26 mrsam Exp $";

#include	"buffer.h"

///////////////////////////////////////////////////////////////////////////
//
// The Token class represents one syntactical element in a recipe file, such
// as a semicolon, a brace, or a text string.  The Lexer class creates
// one Token after another from the recipe file.
//
///////////////////////////////////////////////////////////////////////////

class	Token {

	Buffer	buf;

public:
	enum tokentype {
		error,
		eof,
		qstring,		// Quoted string
		sqstring,		// Sinqle-quoted string
		btstring,		// Backticked string
		equals,
		lbrace,
		rbrace,
		semicolon,
		regexpr,
                plus,
		minus,
		mult,
		divi,
		lt,
		le,
		gt,
		ge,
		eq,
		ne,
		lor,
		land,
		or,
		and,
		lparen,
		rparen,
		not,
		bitwisenot,
		slt,
		sle,
		sgt,
		sge,
		seq,
		sne,
		length,
		substr,
		comma,
		strregexp,
		tokenif,
		tokenelse,
		tokenwhile,
		tokento,
		tokencc,
		exception,
		echo,
		tokenxfilter,
		dotlock,
		flock,
		logfile,
		log,
		include,
		exit,
		foreach,
		getaddr,
		lookup,
		escape,
		to_lower,
		to_upper,
		hasaddr,
		gdbmopen,
		gdbmclose,
		gdbmfetch,
		gdbmstore,
		timetoken,
		importtoken,
		};
private:
	tokentype type;
public:
	Token() : type(error)	{}
	~Token()		{}
	Token(const Token &);	// UNDEFINED
	Token &operator=(const Token &t) { type=t.type; buf=t.buf; return (*this); }

	void Type(tokentype t) { type=t; }
	void Type(tokentype t, const Buffer &tbuf) { type=t; buf=tbuf; }
	tokentype Type() const { return (type); }
	const Buffer &String() const { return (buf); }
	Buffer &String() { return (buf); }

	const char *Name();
} ;
#endif
