/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"deliverdotlock.h"
#include	<stdlib.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: deliverdotlock.C 1.1 1998/04/16 23:53:22 mrsam Exp $";

void DeliverDotLock::cleanup()
{
	truncate();
	DotLock::cleanup();
}

DeliverDotLock::DeliverDotLock() : truncate_fd(-1), truncate_size(0)
{
	constructed();
}

DeliverDotLock::~DeliverDotLock()
{
	destroying();
}

void DeliverDotLock::truncate()
{
	if (truncate_fd >= 0 &&
		ftruncate(truncate_fd, truncate_size) < 0)
	{
	static const char msg[]="Unable to truncate mailbox.\n";

		write(2, msg, sizeof(msg)-1);
	}
	truncate_fd= -1;
}
