#ifndef	rfc1035_res_h
#define	rfc1035_res_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

static const char rfc1035_res_rcsid[]="$Id: rfc1035_res.h,v 1.3 1999/12/22 05:03:23 mrsam Exp $";

#ifdef  __cplusplus
extern "C" {
#endif

#define	MAXNS	10
#define	DEFAULT_INITIAL_TIMEOUT	5
#define	DEFAULT_MAXIMUM_BACKOFF	3

		/* Resolver state */
struct rfc1035_res {

	struct sockaddr_in nameservers[MAXNS];
	const struct sockaddr *nameserversp[MAXNS];
	char *rfc1035_defaultdomain;
	unsigned rfc1035_good_ns;
	int rfc1035_nnameservers;
	unsigned rfc1035_timeout_initial;	/* Initial timeout */
	unsigned rfc1035_timeout_backoff;	/* Maximum exponential backoff */
	unsigned id;
	} ;

extern struct rfc1035_res rfc1035_default_resolver;

#ifdef  __cplusplus
}
#endif

#endif
