/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if HAVE_CONFIG_H
#include "config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<string.h>
#include	<errno.h>

#include	"auth.h"
#include	"authmod.h"
#include	"authldap.h"

static const char rcsid[]="$Id: authldap.c,v 1.5 2000/02/24 13:05:09 mrsam Exp $";


struct callback_info {
	char *userret;
	};

static int callback_ldap(struct authinfo *a, void *p)
{
struct callback_info *i=(struct callback_info *)p;

	/* No need to check passwords, authldaplib did it already */

	{
	static char *env_buf=0;
	char *p;
	const char *d=a->maildir;

		if (!d)	d="";

		p=malloc(sizeof("MAILDIR=")+strlen(d)+1);
		if (!p)
		{
			perror("malloc");
			authexit(1);
		}
		sprintf(p,"MAILDIR=%s", d);
		putenv(p);
		if (env_buf)	free(env_buf);
		env_buf=p;
	}

        if ((i->userret=strdup(a->sysusername)) == 0)
        {
                perror("malloc");
                return (1);
        }

        authsuccess(a->homedir, 0, a->sysuserid, &a->sysgroupid,
                a->address, a->fullname);

        return (0);
}

static char *auth_ldap_login(const char *service, char *authdata, int issession)
{
const char *user, *pass;
struct	callback_info ci;
int	rc;

	if ((user=strtok(authdata, "\n")) == 0 ||
		(pass=strtok(0, "\n")) == 0)
	{
		errno=EPERM;
		return (0);
	}

	rc=authldapcommon(user, pass, &callback_ldap, &ci);

	if (rc)
	{
		errno=EPERM;
		return (0);
	}
	return (ci.userret);
}

#if HAVE_HMACLIB

#include	"../libhmac/hmac.h"
#include	"cramlib.h"

struct cram_callback_info {
	struct hmac_hashinfo *h;
	char *user;
	char *challenge;
	char *response;
	char *userret;
	};

static int callback_cram(struct authinfo *a, void *vp)
{
struct cram_callback_info *cci=(struct cram_callback_info *)vp;
unsigned char *hashbuf;
unsigned char *p;
unsigned i;
static const char hex[]="0123456789abcdef";
int	rc;
char *s;

	if (!a->clearpasswd)
		return (-1);

	/*
		hmac->hh_L*2 will be the size of the binary hash.

		hmac->hh_L*4+1 will therefore be size of the binary hash,
		as a hexadecimal string.
	*/

	if ((hashbuf=malloc(cci->h->hh_L*6+1)) == 0)
		return (1);

	hmac_hashkey(cci->h, a->clearpasswd, strlen(a->clearpasswd),
		hashbuf, hashbuf+cci->h->hh_L);

	p=hashbuf+cci->h->hh_L*2;

	for (i=0; i<cci->h->hh_L*2; i++)
	{
		*p++ = hex[ (p[i] >> 4) & 0x0F];
		*p++ = hex[ p[i] & 0x0F];
		*p=0;
	}

	rc=auth_verify_cram(cci->h, cci->challenge, cci->response,
		(const char *)hashbuf+cci->h->hh_L*2);
	free(hashbuf);

	if (rc)	return (0);

	s=strdup(cci->user);
	if (!s)
	{
		perror("ERR: strdup");
		return (1);
	}
	cci->userret=s;
	return (0);
}

static char *auth_ldap_cram(const char *service,
	const char *authtype, char *authdata)
{
struct	cram_callback_info	cci;
int	rc;

	if (auth_get_cram(authtype, authdata,
		&cci.h, &cci.user, &cci.challenge, &cci.response))
		return (0);

	rc=authldapcommon(cci.user, 0, &callback_cram, &cci);

	if (rc < 0)
	{
		errno=EPERM;
		return (0);
	}
	if (rc > 0)
	{
		errno=EACCES;
		return (0);
	}
	return (cci.userret);
}
#endif

char *auth_ldap(const char *service, const char *authtype, char *authdata,
		int issession)
{
	if (strcmp(authtype, AUTHTYPE_LOGIN) == 0)
		return (auth_ldap_login(service, authdata, issession));

#if HAVE_HMACLIB
	return (auth_ldap_cram(service, authtype, authdata));
#else
	errno=EPERM;
	return (0);
#endif
}
