/*
                            YIFF Global Options

	Also file and directory names structure.
 */

#ifndef OPTIONS_H
#define OPTIONS_H

#include <limits.h>

#include "ytypes.h"
#include "ysound.h"

/*
 *	Options Structure:
 */
typedef struct {

        Boolean         debug;

        /* Listening port number, clients connect to this port number
         * to reach us (this server).
         */
        int port;

        /* Current or last set Audio values. */
        Audio audio;

        /* Refresh interval. */
        YDeltaTime refresh_int;

        /* Command to run midi player. */
        char *midi_play_cmd;

#ifdef ALSA
        /* Midi device number,used by the ALSA driver for multiple MIDI
         * device support.
         */
        int midi_device_number;
#endif  /* ALSA */

} yiff_option_struct; 
extern yiff_option_struct option;


/* 
 *      File names:
 */
typedef struct {

        char rcfile[PATH_MAX + NAME_MAX];
	char mixerrcfile[PATH_MAX + NAME_MAX];

        char device[PATH_MAX + NAME_MAX];
        char mixer[PATH_MAX + NAME_MAX];

} yiff_fname_struct;
extern yiff_fname_struct fname;



#endif	/* OPTIONS_H */
