/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/messagebox.h"
#include "vdk/vdktypes.h"
#include "vdk/separator.h"
#include <gdk/gdkkeysyms.h>

extern char *info_xpm[];
extern char *HandOpen_xpm[]; 
extern char *Question_xpm[];   
extern char *mini_exclam_xpm[];
extern char *blue_ball_xpm[];

DEFINE_EVENT_LIST(MessageBoxWindow,VDKForm);

DEFINE_SIGNAL_MAP(MessageBoxWindow,VDKForm)
  ON_SIGNAL(OkYesButton,clicked_signal,QuitOk),
  ON_SIGNAL(CancelButton,clicked_signal,QuitCancel),
  ON_SIGNAL(timer,timer_tick_signal,OnTimer)
END_SIGNAL_MAP

MessageBoxWindow::MessageBoxWindow(VDKForm* owner,
				   char* caption, 
				   char* prompt, 
				   int mode,
				   char *oktext,
				   char *canceltext,
				   int* answer,
				   unsigned int wait)
  : VDKForm(owner,caption),mode(mode),answer(answer)
{
  if(wait > 0)
    timer = new VDKTimer(this, wait , true);
  else
    timer = NULL;
  if(prompt)
    {
      text = new char[strlen(prompt)+1];
      strcpy(text,prompt);
    }
  else
    text = NULL;
  if(oktext)
    {
      okText = new char[strlen(oktext)+1];
      strcpy(okText,oktext);
    }
  else
    okText = NULL;
  if(canceltext)
    {
      cancelText = new char[strlen(canceltext)+1];
      strcpy(cancelText,canceltext);
    }
  else
    cancelText = NULL;
  OkYesButton = CancelButton = NULL;
}

/*
 */
bool
MessageBoxWindow::OnTimer(VDKObject*)
{
QuitCancel(NULL);
return true;
}
/*
 */
MessageBoxWindow::~MessageBoxWindow()
{
if(text)
  delete[] text;
if(okText)
  delete[] okText;
if(cancelText)
  delete[] cancelText;
}

void 
MessageBoxWindow::Setup()
{
  Add(messageArea = new VDKBox(this,h_box),l_justify,TRUE,TRUE,5);
  Add(new VDKSeparator(this),l_justify,TRUE,TRUE,5);
  Add(buttonArea = new VDKBox(this,h_box),l_justify,TRUE,TRUE,5);
  
  /* masks icon */
  
  switch(mode & MB_ICONMASK)
    {
      
    case MB_ICONQUESTION:
      messageArea->Add(new VDKPixmap(this,Question_xpm));
      break;
      
    case MB_ICONINFORMATION:
      messageArea->Add(new VDKPixmap(this,info_xpm));
      break;
      
    case MB_ICONSTOP:
    default:
      messageArea->Add(new VDKPixmap(this,HandOpen_xpm));         
    }
  
  if(text) 
    messageArea->Add(new VDKLabel(this,text));
  /* mask buttons */
  char* yes = "_Yes";
  char* no = "_No";
  switch(mode & MB_TYPEMASK)
    {
      //cancel_xpm
    case MB_YESNO:
      OkYesButton = new VDKCustomButton(this,
					mini_exclam_xpm,
					okText ? okText : yes);
      buttonArea->Add(OkYesButton,l_justify,true,false,5);
      CancelButton = new VDKCustomButton(this,
					 blue_ball_xpm,
					 cancelText ? cancelText :no);
      buttonArea->Add(CancelButton,l_justify,true,false,5);
      break;
    case MB_OK:
      OkYesButton = new VDKCustomButton(this,
					mini_exclam_xpm,
					okText ? okText : yes);
      buttonArea->Add(OkYesButton,l_justify,true,false,5);
      break;
    default:
      break;
    }
  // use CR for ok-yes, Esc for cancel-no 
  EventConnect("key_release_event",&MessageBoxWindow::OnKeyRelease);
}

bool
MessageBoxWindow::OnKeyRelease(VDKObject* obj, GdkEvent* ev)
{
  GdkEventKey* event = (GdkEventKey*) ev;
  if(event->keyval == GDK_Return)
    QuitOk(NULL);
  else if(event->keyval == GDK_Escape)
    QuitCancel(NULL);
  return true;
}
/*
 */
bool
MessageBoxWindow::QuitOk(VDKObject*)
{
if( (mode & MB_TYPEMASK) == MB_YESNO)
  *answer = IDYES;
else
  *answer = IDOK;
if(timer)
  timer->Stop();
Close();
return true;
}
/*
 */
bool 
MessageBoxWindow::QuitCancel(VDKObject*)
{
if( (mode & MB_TYPEMASK) == MB_YESNO)
  *answer = IDNO;
else
  *answer = IDCANCEL;
if(timer)
  timer->Stop();
Close();
return true;
}



