#ifndef _testclasses_h_
#define _testclasses_h_
#include <vdk/vdk.h>
/* -*- c++ -*- */
/** Each of these classes will watch a corresponding vdkobject.
    That means, it will subsrcibe for all of its signals, translate
    them to a string and finaly emit the OnMesg-Signal with this 
    string.

    Overview:

    VDKObjectTest
    +  VDKAbstractButtonTest
    |  +  VDKCheckButtonTest
    |  \  VDKToggleButtonTest
    |
    +  VDKComboTest
    |
    +  VDKCustomTest
    |  +  VDKCustomListTest
    |  \   VDKCustomTreeTest
    |
    +  VDKSpinButtonTest
*/

class VDKObjectTest : public SigC::Object
{
 protected:
     char* _classname;
 public:
     VDKObjectTest(VDKObject*);
     VDKSignal1<void, const char*> OnMesg;
 private:
     void onkeypress_response(VDKObject* obj, char* key);
     void onkeyrelease_response(VDKObject* obj, char* key);
};

class VDKAbstractButtonTest : public VDKObjectTest
{
 public:
     VDKAbstractButtonTest(VDKAbstractButton*);
 private:
     void onbtnclicked_resp(VDKObject* obj);
     void onbtnpressed_resp(VDKObject* obj);
     void onbtnleave_resp(VDKObject*);
};

class VDKCheckButtonTest : public VDKAbstractButtonTest
{
 public:
     VDKCheckButtonTest(VDKCheckButton*);
 private:
     void onbtntog_resp(VDKObject*, bool);
};

class VDKToggleButtonTest : public VDKAbstractButtonTest
{
 public:
     VDKToggleButtonTest(VDKToggleButton*);
 private:
     void onbtntog_resp(VDKObject*, bool);
};

class VDKSpinButtonTest : public VDKObjectTest
{
 public:
     VDKSpinButtonTest(VDKSpinButton*);
 private:
     void onvaluechanged(VDKObject*, float);
};

class VDKCustomTest : public VDKObjectTest
{
 public:
     VDKCustomTest(VDKCustom*);
 private:
     void oncolumnclick(VDKObject*, int);
};

class VDKCustomListTest : public VDKCustomTest
{
 public:
     VDKCustomListTest(VDKCustomList*);
 private:
     void onrowselect(VDKObject*,int, int);
     void onrowunselect(VDKObject*,int, int);
     void onrowmove(VDKObject*,int,int);
/*      void onrowinsert(VDKObject*,int, const char**); */
/*      void onrowremove(VDKObject*,int); */
};

class VDKCustomTreeTest : public VDKCustomTest
{
 public:
     VDKCustomTreeTest(VDKCustomTree*);
 private:
     void onnodeselect(VDKObject*, VDKTreeNode, int);
     void onnodeunselect(VDKObject*, VDKTreeNode, int);
     void ontreemove(VDKObject*, VDKTreeNode, VDKTreeNode, VDKTreeNode);
};

class VDKComboTest : public VDKObjectTest
{
 public:
     VDKComboTest(VDKCombo*);
 private:
     void onitemactivate(VDKObject*,int item);
     void onitemselect(VDKObject*,int item);
     void onitemunselect(VDKObject*, int item);
     void onitemtextchanged(VDKObject*, int item, const char* text);
};

#endif
