/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.6
 * Revision 2
 * June 1999
 * ===========================
 * VDKColorBrowser
 * ===========================
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _vdk_color_browser_h
#define _vdk_color_browser_h
#include <vdk/vdk.h>
//////////////////////////////
#define MAX_COL 5
#define RGBTEXT1 "/usr/X11R6/lib/X11/rgb.txt"
#define RGBTEXT2 "/var/X11R6/lib/rgb.txt"

typedef struct VDKDefaultColors
{
  char* colorname;
  int red,green,blue;
};

class RGBColor
{
 public:
  VDKString name;
  int red,green,blue;
  RGBColor():name(""),red(0),green(0),blue(0) {}
  RGBColor(char* name, int red, int green, int blue):
    name(name),red(red),green(green),blue(blue) {}
  bool operator < (RGBColor& rgb)
    { return name < rgb.name; }
  bool operator == (RGBColor& rgb)
    { return name == rgb.name; }
};

typedef VDKValueList<RGBColor> RGBColorList;
typedef VDKValueListIterator<RGBColor> RGBColorListIterator;

class VDKColorBrowserParms
{
 public:
  VDKRgb rgb;
  char colorname[64];
  char *title,*ok,*cancel,*loadvdk,*loadrgb;
  VDKColorBrowserParms():
    rgb(-1,-1,-1),
    title(NULL),
    ok(NULL),
    cancel(NULL),
    loadvdk(NULL),
    loadrgb(NULL) { *colorname = '\0';}
  ~VDKColorBrowserParms() {}

};


//////////////////////////////
class VDKColorBrowser: public VDKForm
{
  VDKGrid *grid;
  VDKScrolled *scrolled;
  VDKCustomButton *ok,*cancel,*loadvdk,*loadrgb;
  VDKStatusbar *statbar;
  void InitGrid();
  void LoadVDKGrid();
  bool ReadRGB();
  void LoadRGB();
  VDKColorBrowserParms* parms;
  RGBColorList colors;

public:
  VDKColorBrowser(VDKForm* owner, VDKColorBrowserParms* parms = NULL):
    VDKForm(owner, (char*) NULL),parms(parms) {}
  ~VDKColorBrowser() {}
  void Setup();
  void OnShow(VDKForm* sender);
  bool OkClicked(VDKObject*);
  bool CancelClicked(VDKObject*);
  bool LoadVdkClicked(VDKObject*);
  bool LoadRgbClicked(VDKObject*);
  bool OnSelectCell(VDKObject*);
  DECLARE_SIGNAL_MAP(VDKColorBrowser);

};
#endif




