/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Modify by Salmaso Raffaele <r.salmaso@flashnet.it> 10 Jan 1999
 * added 2 property: Caption and CaptionWrap
 * added 2 constructor options: position and padding
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef  PIX_BUTTON_H
#define  PIX_BUTTON_H

#include <vdk/button.h>

class VDKPixmapButton: public VDKButton
{
    GtkWidget *lbl, *box, *pixmap;
    GdkPixmap *gdkpixmap;

public:
    VDKReadWriteValueProp<VDKPixmapButton, char*> Caption;
    VDKReadWriteValueProp<VDKPixmapButton, bool> CaptionWrap;
    VDKPixmapButton (VDKForm* owner,
                     char* pixfile,
                     char* label = NULL,
	             char* tip = NULL,
                     bool defButton = no,
                     GtkPositionType position = GTK_POS_RIGHT,
                     int padding = 0);
    VDKPixmapButton(VDKForm* owner,
                    char** pixdata,
                    char* label = NULL,
                    char* tip = NULL,
                    bool defButton = no,
                    GtkPositionType position = GTK_POS_RIGHT,
                    int padding = 0);
    virtual ~VDKPixmapButton();
    virtual void SetForeground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);
    virtual void SetFont(VDKFont* font);
    virtual void Enable (bool flag = true);

    void SetCaption (char* str);
    char* GetCaption ();
    void SetCaptionWrap (bool flag);
    void SetPixmap(char* pixfile);
    bool GetCaptionWrap ();
  
};
#endif
