/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/

#include "wnlib.h"

#include "wnvect.h"



/***************************************************************************

  This must be as fast as possible, because it is the inner loop for most
  n^3 matrix algebra algorithms.  That is why the code is so ugly.

***************************************************************************/
void wn_add_scaled_vect
(
  register double *to_vect,
  register double *from_vect,
  register double scalar,
  int len
)
{
small:
  switch(len)
  {
    case(16):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(15):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(14):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(13):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(12):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(11):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(10):   *(to_vect++) += (scalar*(*(from_vect++)));
    case(9):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(8):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(7):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(6):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(5):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(4):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(3):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(2):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(1):    *(to_vect++) += (scalar*(*(from_vect++)));
    case(0):    return;
    default:
    {
      do
      {
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));
        *(to_vect++) += (scalar*(*(from_vect++)));

	len -= 16;
      }
      while(len > 16);

      goto small;
    }
  }
}

