/********************************************************************************
*                                                                               *
*                            O b j e c t   L i s t                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXObjectList.h,v 1.1 1999/09/14 13:32:48 jeroen Exp $                   *
********************************************************************************/
#ifndef FXOBJECTLIST_H
#define FXOBJECTLIST_H



class FXAPI FXObjectList : public FXObject {
  FXDECLARE(FXObjectList)
protected:
  FXObject  **data;		// List of items
  FXint       num;		// Used slots
  FXint       max;		// Total slots
public:

  // Constructor
  FXObjectList();

  // Return number of elements
  FXint no() const { return num; }

  // Set number of elements
  void no(FXint n);

  // Return size of list
  FXint size() const { return max; }

  // Set max number of elements
  void size(FXint m);
    
  // Access to constant list
  FXObject* const& operator[](FXint i) const { FXASSERT(i<num); return data[i]; }
  FXObject* const& list(FXint i) const { FXASSERT(i<num); return data[i]; }
  
  // Access to list
  FXObject*& operator[](FXint i){ FXASSERT(i<num); return data[i]; }
  FXObject*& list(FXint i){ FXASSERT(i<num); return data[i]; }
  
  // Access to content array
  FXObject** list() const { return data; }

  // Insert element at certain position
  void insert(FXint pos,FXObject* p);

  // Append element
  void append(FXObject* p);

  // Remove element at pos
  void remove(FXint pos);

  // Remove element p
  void remove(const FXObject* p);

  // Remove all elements
  void clear();

  // Check if element in list, return position
  FXbool find(FXint& pos,const FXObject *p) const;

  // Implements saving/loading
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);

  // Destructor
  virtual ~FXObjectList();
  };


// Specialize list to pointers to TYPE
template<class TYPE>
class FXObjectListOf : public FXObjectList {
public:
  FXObjectListOf(){}
  
  // Access to constant list
  TYPE *const& operator[](FXint i) const { FXASSERT(i<num); return(TYPE *const&)data[i]; }
  TYPE *const& list(FXint i) const { FXASSERT(i<num); return(TYPE *const&)data[i]; }
  
  // Access to list
  TYPE*& operator[](FXint i){ FXASSERT(i<num); return(TYPE*&)data[i]; }
  TYPE*& list(FXint i){ FXASSERT(i<num); return (TYPE*&)data[i]; }
  
  // Access to content array
  TYPE** list() const { return (TYPE**)data; }
  };

#endif
