/********************************************************************************
*                                                                               *
*                      M e n u   C a s c a d e   W i d g e t                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuCascade.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                   *
********************************************************************************/
#ifndef FXMENUCASCADE_H
#define FXMENUCASCADE_H


class FXMenuPane;


// Cascade menu item
class FXAPI FXMenuCascade : public FXMenuCaption {
  FXDECLARE(FXMenuCascade)
protected:
  FXMenuPane *pane;
  FXTimer*    timer;
protected:
  FXMenuCascade(){}
  void drawTriangle(FXDCWindow& dc,FXint l,FXint t,FXint r,FXint b);
private:
  FXMenuCascade(const FXMenuCascade&);
  FXMenuCascade &operator=(const FXMenuCascade&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onTimeout(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onCmdPost(FXObject*,FXSelector,void*);
  long onCmdUnpost(FXObject*,FXSelector,void*);
public:
  enum {
    ID_MENUTIMER=FXMenuCaption::ID_LAST,
    ID_LAST
    };
public:
  FXMenuCascade(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXMenuPane* pup=NULL,FXuint opts=0);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual FXbool canFocus() const;
  virtual void setFocus();
  virtual void killFocus();
  void setPopup(FXMenuPane *pup){ pane = pup; }
  FXMenuPane* getPopup() const { return pane; }
  virtual FXbool contains(FXint parentx,FXint parenty) const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXMenuCascade();
  };


#endif
