""" Timezone information.

    XXX This module still has prototype status and is undocumented.

    XXX Double check the offsets given in the zonetable below.

    (c) 1998, Copyright Marc-Andre Lemburg; All Rights Reserved.
    See the documentation for further information on copyrights,
    or contact the author (mal@lemburg.com).

"""
import DateTime
import re,string

### REs for time zone parsing (groupname is always 'zone')
isozone = ('(?P<zone>[+-]\d\d:?(?:\d\d)?|Z)')
zone = ('(?P<zone>[A-Z]+|[+-]\d\d:?(?:\d\d)?)')
isozoneRE = re.compile(zone)
zoneRE = re.compile(zone)

### Time zone offset table
#
# The offset given here represent the difference between UTC and the
# given time zone.
#
zonetable = {
              # Timezone abbreviations
	      # Std     Summer

              # Standards
              'UT':0,
	      'UTC':0,
	      'GMT':0,

	      # A few common timezone abbreviations
	      'CET':1,	'CEST':2, # Central European
	      'MET':1,	'MEST':2, # Mean European
	      'MEZ':1,	'MESZ':2, # Mitteleuropische Zeit
	      'EET':2,	'EEST':3, # Eastern Europe
	      'WET':0,	'WEST':1, # Western Europe
	      'MSK':3,	'MSD':4,  # Moscow
	      'IST':5.3,	  # India
	      'JST':9,		  # Japan
	      'KST':9,		  # Korea

	      # US time zones
              'AST':-4, 'ADT':-3, # Atlantic
              'EST':-5, 'EDT':-4, # Eastern
              'CST':-6, 'CDT':-5, # Central
              'MST':-7, 'MDT':-6, # Midwestern
              'PST':-8, 'PDT':-7, # Pacific

	      # US military time zones
	      'Z': 0,
	      'A': 1,
	      'B': 2,
	      'C': 3,
	      'D': 4,
	      'E': 5,
	      'F': 6,
	      'G': 7,
	      'H': 8,
	      'I': 9,
	      'K': 10,
	      'L': 11,
	      'M': 12,
	      'N':-1,
	      'O':-2,
	      'P':-3,
	      'Q':-4,
	      'R':-5,
	      'S':-6,
	      'T':-7,
	      'U':-8,
	      'V':-9,
	      'W':-10,
	      'X':-11,
	      'Y':-12
              }    

_zoneoffset = re.compile('(?P<sign>[+-])(?P<value>\d\d:?(?:\d\d)?)')

def utc_offset(zone,

	       atoi=string.atoi,zoneoffset=_zoneoffset,
	       zonetable=zonetable,zerooffset=DateTime.DateTimeDelta(0),
	       oneMinute=DateTime.oneMinute):

    """ utc_offset(zonestring)

        Return the UTC time zone offset as DateTimeDelta instance.

        zone must be string and can either be given as +-HH:MM,
        +-HHMM, +-HH numeric offset or as time zone
        abbreviation. Daylight saving time must be encoded into the
        zone offset.

    """
    if zone is None:
	return zerooffset
    if zonetable.has_key(zone):
	return zonetable[zone]*DateTime.oneHour
    offset = zoneoffset.match(zone)
    if not offset:
	raise ValueError,'wrong format or unkown time zone: "%s"' % zone
    sign,value = offset.groups()
    if ':' in value:
	value = atoi(value[:2])*60 + atoi(value[3:])
    elif len(value) <= 2:
	value = atoi(value)*60
    else:
	value = atoi(value[:2])*60 + atoi(value[2:])
    if sign == '-':
	value = -value
    return value*oneMinute

