#
# FILE            $Id: HTMLindex.py,v 1.5 1996/07/12 15:57:54 omfadmin Exp $
#
# DESCRIPTION     Generate documentation from python files.
#
# AUTHOR          SEISY/LKSB Daniel Larsson
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of ABB Industrial Systems
# not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior permission.
#
# ABB INDUSTRIAL SYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL ABB INDUSTRIAL SYSTEMS BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# Copyright (C) ABB Industrial Systems AB, 1996
# Unpublished work.  All Rights Reserved.
# 
# HISTORY: $Log: /Gendoc/HTMLindex.py $
# 
# 1     98-04-01 13:15 Daniel
# Revision 1.5  1996/07/12  15:57:54  omfadmin
# Added "gendoc." in front of VERBOSE.
#
# Revision 1.4  1996/07/12  15:53:04  omfadmin
# More fixes by Robin Friedrich.
#
# Revision 1.3  1996/07/10  03:05:07  omfadmin
# Added frame support as per Robin Friedrich's suggestions.
# Made it optional through the FRAME=yes flag.
#
# Revision 1.2  1996/07/08  05:29:32  omfadmin
# Write index file into 'index.html', and use head only in title.
#
# Revision 1.1  1996/06/24  09:54:16  omfadmin
# Initial revision
#
#

"""Generate HTML index page.

Defines the function ~index_page~, which will generate an index file
for a set of modules. If the HTMLgen module is available, it will be
used to create the file, otherwise the layout is hardcoded in this
function. ~index_page~ is really just a pointer to one of the two
functions defined in this module."""

HTML_HEAD = """<!DOCTYPE HTML PUBLIC "-//Netscape_Microsoft//DTD HTML 3.0//EN">
<HTML>
<!-- This file generated by gendoc %s -->
<HEAD>
<TITLE>%s - Manual Index</TITLE>
</HEAD>
"""

import os

def index_page_HTMLgen(dir, head, modules, files):
    """Generate index page using HTMLgen.

    Generates an index page of all modules given on the
    command line."""

    import os, gendoc

    # Figure out if we should generate index with HTML Frames
    frames = 0
    if os.environ.has_key('FRAME') and os.environ['FRAME'][0] in 'yY':
	if gendoc.VERBOSE:
	    print "Generating index using HTML frames"
	frames = 1

    from formatters.HTMLgenFormatter import html_rc, HTMLg

    attribution = HTMLgen.Comment('This file generated by gendoc %s' % gendoc.__version__)
    doc = HTMLgen.Document(html_rc())
    doc.title = "%s - Manual Index" % head

    if frames:
	doc.place_nav_buttons = None
	initialfile = files[0][0]
	top_filename = 'index_frm'
	target = 'body_frame'
	indent = 0
    else:
	top_filename = 'index'
	target = ''
	indent = 1

    doc.append(attribution)

    from string import find

    modlist = []
    for module, files in map(None, modules, files):
	if gendoc.VERBOSE > 1:
	    print 'Adding module %s to index' % module
        modlist.append(HTMLgen.Href(files[0], module, target=target))

	if len(files) > 1:
	    elemlist = []
	    modlist.append(elemlist)
	    for f in files[1]:
		if gendoc.VERBOSE > 1:
		    print 'Adding %s to index' % f
		# HTML files are prepended with module name and 
		# a '-' character. Remove that and the trailing
		# '.html'
		name = f[:-5]
		pos = find(name, '-')
		if pos != -1:
		    name = name[pos+1:]
		elemlist.append(HTMLgen.Href(f, name, target=target))

    doc.append(HTMLgen.List(modlist, indent=indent))
    doc.write(os.path.join(dir, top_filename + HTMLg.file_ext))

    if frames:
	# Create a Framed document to act as a handy navigator tool.
	print 'I\'ve been FRAMED!!'
	fdoc = HTMLgen.FramesetDocument( attribution, title = head )
	fset = HTMLgen.Frameset(cols='220,*', frame_warning=None)
	findex = HTMLgen.Frame(name='index_frame', src= top_filename + HTMLg.file_ext )
	fbody = HTMLgen.Frame(name='body_frame', src=initialfile)
	fset.append(findex, fbody)
	fdoc.append(fset)
	fdoc.write(os.path.join(dir, 'index' + HTMLg.file_ext))

HTML_PRFX = HTML_HEAD + """<BODY>
<H1>%s - Manual Index</H1>
"""

def index_page_std(dir, head, modules, files):
    """Generate index page.

    Generates an index page of all modules given on the
    command line."""

    file = open(os.path.join(dir, 'index.html'), 'w')
    file.write(HTML_PRFX % (__version__, head, head))

    file.write('<UL>\n')

    import gendoc
    from string import find

    for module, files in map(None, modules, files):
	if gendoc.VERBOSE > 1:
	    print 'Adding module %s to index' % module.__name__
	file.write('<LI><A HREF="%s">%s</A>\n' % (files[0], module.__name__))
	if len(files) > 1:
	    file.write('<UL>\n')
	    for f in files[1]:
		if gendoc.VERBOSE > 1:
		    print 'Adding %s to index' % f
		# HTML files are prepended with module name and 
		# a '-' character. Remove that and the trailing
		# '.html'
		name = f[:-5]
		pos = find(name, '-')
		if pos != -1:
		    name = name[pos+1:]
		file.write('<LI><A HREF="%s">%s</A>\n' % (f, name))
	    file.write('</UL>\n')
    file.write('</UL>\n')
    import time
    file.write('<HR>\n<ADDRESS>Generated by gendoc.py %s at %s</ADDRESS>\n' % (__version__, time.asctime(time.localtime(time.time()))))
    file.write('</BODY></HTML>\n')


try:
    import HTMLgen
    index_page = index_page_HTMLgen
except:
    index_page = index_page_std
