/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* menu_util.c	menu utilities for xconvers
 */

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>

#include "menu_util.h"

/*---------------------------------------------------------------------------
 * CascadeButton 
 */
Widget CascadeButton(parent, name, pulldown)
	Widget	parent;
	String	name;
	Widget	pulldown;
{
  Widget	cascade;
  Arg		arg[1];

  XtSetArg(arg[0], XmNsubMenuId, pulldown);
  cascade = XmCreateCascadeButton(parent, name, arg, 1);
  XtManageChild(cascade);
  return(cascade);
}


/*---------------------------------------------------------------------------
 * CreatePulldownPane
 */
Widget CreatePulldownPane(parent, name)
	Widget	parent;
	String	name;
{
  return(XmCreatePulldownMenu(parent, name, NULL, 0));
}


/*---------------------------------------------------------------------------
 * PushButton
 */
Widget PushButton(parent, name, callback, client_data)
	Widget	parent;
	String	name;
	void (*callback)(Widget widget, caddr_t  client_data, caddr_t call_data);
	caddr_t	client_data;
{
  Widget	push;
  
  push = XmCreatePushButton(parent, name, NULL, 0);
  if(callback)
	XtAddCallback(push, XmNactivateCallback,(XtCallbackProc)callback, client_data);
  XtManageChild(push);
  return(push);
}


/*---------------------------------------------------------------------------
 * ToggleButton
 */
Widget ToggleButton(parent, name, callback, client_data)
	Widget	parent;
	String	name;
	void (*callback)(Widget widget, caddr_t  client_data, caddr_t call_data);
	caddr_t	client_data;
{
  Widget	toggle;
  
  toggle = XmCreateToggleButton(parent, name, NULL, 0);
  if(callback)
	XtAddCallback(toggle, XmNactivateCallback, (XtCallbackProc)callback, client_data);
  XtManageChild(toggle);
  return(toggle);
}


/*---------------------------------------------------------------------------
 * Separator
 */
Widget Separator(parent)
	Widget	parent;
{
  Widget	sep;
  
  sep = XmCreateSeparator(parent, "separator", NULL, 0);
  XtManageChild(sep);
  return(sep);
}


/*---------------------------------------------------------------------------
 * Label
 */
Widget Label(parent, name)
	Widget	parent;
	String	name;
{
  Widget	label;
  
  label = XmCreateLabel(parent, name, NULL, 0);
  XtManageChild(label);
  return(label);
}

