/*
 * afosin.c
 *
 * This module handles the afos-in designation
 *
 * $Id: afosin.c,v 1.2 1996/08/19 06:14:08 ron Exp $
 *
 * $Log: afosin.c,v $
 * Revision 1.2  1996/08/19 06:14:08  ron
 * Checkpoint: Config file parsing compiled and first-pass testing complete
 *
 * Revision 1.1  1996/08/19 02:42:18  ron
 * Initial check-in, no compile yet.  Roughed skeleton.
 *
 *
 */
#include <unistd.h>
#include <stdio.h>
#include "afos.h"

int afosin_init ( AF_CHANNEL *chan ) ;
int afosin_getchar ( AF_CHANNEL *chan ) ;

typedef struct _AFOSIN_STRUCT_ {
	char channel_name[AFCHAN_NAME_SIZE];
	} AFOSIN_STRUCT ;

/*
	parse_afosin parses out the 'afos-in' line in the config file
*/
int
parse_afosin( char *line )
{
	static char args[2][80] ;
	AF_CHANNEL *chan ;
	AFOSIN_STRUCT *mystuff ;
	int count ;

	count = sscanf ( line,  "%[^ 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]",
		args[0], args[1] ) ;

	if ( count < 2 )
	{
		fprintf ( stderr, "\r\nAFOSD: Unable to parse the following line:\n%s\n"
			"Insufficient parameters for afos-in designation\n"
			"Usage:\n"
	"afos-in <CHANNEL NAME>\n", line);
		exit (-1);
	}

	strncpy ( afos_in_channel_name, args[1], AFCHAN_NAME_SIZE ) ;

#if 1
	printf( "config line: '%s'\n"
			"designated afos input channel: '%s'\n",
			line, afos_in_channel_name ) ;
#endif
}


/*
	file_init initializes a file channel
*/
int
afosin_init ( AF_CHANNEL *chan )
{
	/* 
		Verify channel is defined, set-up select entry, etc.
	*/

	if (verify_unique_portname(((AFOSIN_STRUCT *)chan->private)->channel_name))
	{
		fprintf(stderr,"\r\nERROR in port configuration file\n%s\n"
					   "afos-in designated port '%s' is un-defined\n",
						((AFOSIN_STRUCT *)chan->private)->channel_name) ;
		exit (-1);
	}
}

/*
	afosin_getchar reads one character from the file channel.  This call is
	non-blocking and may return a negative value if an error occurs
*/
int
afosin_getchar ( AF_CHANNEL *chan )
{
	int i, result;

	result = read ( chan->fd, &i, 1 ) ;

	if ( result <= 0 )
		return -1 ;

	return i ;
}
