/******************************************************************************
    Xplanet 0.43 - render an image of the earth into an X window
    Copyright (C) 1999 Hari Nair <hari@alumni.caltech.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

******************************************************************************/

#include <time.h>

extern const float deg_to_rad;
extern const float TWO_PI;

extern double kepler (double e, double M);
extern double poly (double a1, double a2, double a3, double a4, double t);
extern double jcentury (time_t tv_sec);
extern double compute_obliquity ( double T );
extern void compute_ra_dec (double lon, double lat, double &alpha, 
			    double &delta, double eps);
extern double gmst (double T, time_t tv_sec);

extern void rotate_xyz (double matrix[3][3], float angle_x, 
			float angle_y, float angle_z);
extern void rotate_zyx (double matrix[3][3], float angle_x, 
			float angle_y, float angle_z);
