/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogTerrace.h"
#include "TFOptions.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "GuiDialogOAC.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogTerrace::TFDialogTerrace (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Terrace Dialog", 
				"Terrace: group elevation levels", 6, 4), 
		  d_vbList (TRUE, 5),
		  d_hbNLevels (TRUE, 5),
		  d_hbTightness (TRUE, 5),
		  d_hbAdjustSea (TRUE, 5),
		  d_adjNLevels (10, 1.0, (TFOptions::s_large ? 500 : 50), 0.01),
		  d_adjTightness (0.75, 0.0, 1.0, 0.01),
		  d_hsNLevels (d_adjNLevels),
		  d_hsTightness (d_adjTightness),
		  d_lblNLevels (_("Number of Levels")),
		  d_lblTightness (_("Tightness Factor")),
		  d_lblAdjustSea (_("Adjust Waterlevel")),
		  d_frmOptions (_("Terrace Parameters"))

{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogTerrace\n");
	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Terrace: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (d_adjNLevels.value_changed, this, &TFDialogTerrace::updatePreviewCallback);
	connect_to_method (d_adjTightness.value_changed, this, &TFDialogTerrace::updatePreviewCallback);
	connect_to_method (d_btnAdjustSea.clicked, this, &TFDialogTerrace::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogTerrace::~TFDialogTerrace ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogTerrace\n");
}


/*
 *  insertOptions: insert the dialogs actual options 
 */
void TFDialogTerrace::insertOptions ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogTerrace called without Frame label",
		"TFDialogTerrace ::setHFobjs");

	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	d_hbNLevels.pack_start (d_lblNLevels, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblNLevels.show ();
	d_hsNLevels.set_update_policy (GTK_UPDATE_CONTINUOUS);
	d_hsNLevels.set_digits (0);
	d_hsNLevels.set_draw_value (TRUE);
	d_hbNLevels.pack_end (d_hsNLevels, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hsNLevels.show ();
	d_vbList.pack_start (d_hbNLevels, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbNLevels.show ();

	d_hbTightness.pack_start (d_lblTightness, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblTightness.show ();
	d_hsTightness.set_update_policy (GTK_UPDATE_CONTINUOUS);
	d_hsTightness.set_digits (2);
	d_hsTightness.set_draw_value (TRUE);
	d_hbTightness.pack_end (d_hsTightness, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hsTightness.show ();
	d_vbList.pack_start (d_hbTightness, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbTightness.show ();

	d_hbAdjustSea.pack_start (d_lblAdjustSea, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblAdjustSea.show ();
	d_btnAdjustSea.set_active (TRUE);
	d_hbAdjustSea.pack_end (d_btnAdjustSea, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_btnAdjustSea.show ();
	d_vbList.pack_start (d_hbAdjustSea, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbAdjustSea.show ();

	d_frmOptions.add (d_vbList);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 3);
	d_vbList.show ();
	d_frmOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();

}



void TFDialogTerrace::buildDialogWindow ()
{
	this->set_usize (450, 225);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();
	
	this->show ();
}


/*
 *  buttonCallbackApply: transform the height field
 */
void TFDialogTerrace::buttonCallbackApply ()
{
	float		tightness=d_adjTightness.get_value (),
			value=d_adjNLevels.get_value ();
	bool		adjSealevel=d_btnAdjustSea.get_active();

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogTerrace::buttonCallbackApply");

	p_HFO->terrace (value, tightness, adjSealevel);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a widget has been updated. 
 */
void TFDialogTerrace::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	float		tightness=d_adjTightness.get_value (),
			value=d_adjNLevels.get_value ();
	bool		adjSealevel=d_btnAdjustSea.get_active();

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogFill::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogFill::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFDialogFill::updatePreviewCallback");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	p_HFOPreview->terrace (value, tightness, adjSealevel);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
}


