/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_DIALOG_PREVIEW_H
#define _GUI_DIALOG_PREVIEW_H


#include <gtk--.h>
#include <gtk/gtk.h>
#include "GuiBufferedDrawingArea.h"


class GuiDialogPreview : public Gtk_Dialog
	{
	public: 
				GuiDialogPreview (char *windowTitle, char *frameTitle, 
						  int tableX, int tableY);
				~GuiDialogPreview (); 
		void		clearPreview ();
		virtual void	buildDialogWindow ();
		static void	iterateEvents ();

	protected:
		void		fillActionArea ();
		void		setupVBox ();
		void		insertPreview ();
		virtual void 	buttonCallbackOK ();
		virtual void 	buttonCallbackApply ();
		virtual void 	buttonCallbackCancel ();
		virtual void	checkboxCallbackPreview ();
		virtual gint 	delete_event_impl (GdkEventAny *);
		virtual void	insertOptions ();

		bool			b_applyHit;
		int			d_size, 
					d_frameBorder;
		Gtk_VBox		d_vbPreview;
		Gtk_Button		d_btnOK,
					d_btnApply,
					d_btnCancel;
		Gtk_CheckButton		d_cbUsePreview;
		Gtk_Frame		*p_frmBase,
					*p_frmPreview,
					*p_frmPreviewGroup;
		Gtk_Preview		*p_pvwMain;
		GuiBufferedDrawingArea	*p_drawArea;
		Gtk_Table		*p_tblMain;
		char			*p_windowTitle, 
					*p_frameTitle;
	};


#endif // _GUI_DIALOG_PREVIEW_H
