/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include "terraform.h"
#include "GuiDialogAbout.h"				// include gtk, gtk--
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "MathRandom.h"



/*
 * Constructor: init everything 
 */
GuiDialogAbout::GuiDialogAbout (char *winTitle, char *filename, 
				char **msgPtrs, int nMesgs)
		: Gtk_Window (),
		  d_preview (GTK_PREVIEW_COLOR),
#ifdef HAVE_IMLIB
		  d_vBox (FALSE, 0),
		  d_frame (),
	 	  d_vBoxFrame (FALSE, 0)
#else
		  d_vBox (FALSE, 0)
#endif
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ GuiDialogAbout\n");

	SanityCheck::bailout ((!winTitle), "winTitle==NULL", "GuiAboutDialog::GuiAboutDialog");

	p_winTitle = strdup (winTitle);
	p_msgPtrs = msgPtrs;
	d_nMessage = nMesgs;
	p_lblPtrs = NULL;
	this->set_events (GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK);

#ifdef HAVE_IMLIB
	SanityCheck::bailout ((!filename), "filename==NULL", "GuiAboutDialog::GuiAboutDialog");
	SanityCheck::bailout ((!strlen (filename)), "strlen(filename)==0", "GuiAboutDialog::GuiAboutDialog");
	p_image = NULL;
	p_imageFile = strdup (filename);
#endif

	connect_to_method (button_press_event, this, 
			&GuiDialogAbout::handleButtonPressEvent);
}


/*
 * Destructor
 */
GuiDialogAbout::~GuiDialogAbout ()
{
	if (p_lblPtrs)
		{
		for (int i=0; i<d_nMessage; i++)
			delete p_lblPtrs[i];
		delete [] p_lblPtrs;
		}
	if (p_winTitle)
		free (p_winTitle);
#ifdef HAVE_IMLIB
	if (p_imageFile)
		free (p_imageFile);
#endif

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- GuiDialogAbout\n");
}


/*
 *  (virtual) buildDialogWindow: call the proper functions to setup the window
 */
void GuiDialogAbout::buildDialogWindow ()
{
        this->set_title (p_winTitle);
	this->add (d_vBox);
        d_vBox.set_border_width (0);

#ifdef HAVE_IMLIB
	loadLogo ();
	d_vBox.pack_start (d_preview, TRUE, TRUE, 0);
	d_preview.show ();

	d_vBox.pack_start (d_frame, TRUE, TRUE, 0);
	d_frame.show ();
	d_frame.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frame.add (d_vBoxFrame);

	addLabels (&d_vBoxFrame);
	d_vBoxFrame.show ();

	//printf ("%d\n", d_lbl1->height());
	// how do I calculate the proper window height? 
	// d_lbl1->height() returns 1
	this->set_usize (p_image->rgb_width, p_image->rgb_height+15*d_nMessage);
#else
	addLabels (&d_vBox);
	this->set_usize (150, 75);
#endif

        d_vBox.show ();
        this->show ();
}


void GuiDialogAbout::addLabels (Gtk_VBox *vbox)
{
	char	buf[80];

	SanityCheck::bailout ((!vbox), "vbox==NULL", "GuiAboutDialog::addLabels");

	if (!p_msgPtrs)
		return;

	p_lblPtrs = new Gtk_Label*[++d_nMessage];

	sprintf (buf, "Version %d.%d.%d", 
		TF_MAJOR_VERSION, TF_MINOR_VERSION, TF_MICRO_VERSION);
	p_lblPtrs[0] = new Gtk_Label (buf);
	vbox->pack_start (*(p_lblPtrs[0]), FALSE, FALSE, 0);
	p_lblPtrs[0]->show ();

	for (int i=1; i<d_nMessage; i++)
		{
		p_lblPtrs[i] = new Gtk_Label (p_msgPtrs[i-1]);
		vbox->pack_start (*(p_lblPtrs[i]), FALSE, FALSE, 0);
		p_lblPtrs[i]->show ();
		}
}


/*
 *  (virtual) handleButtonPressEvent: catch a pressed button 
 */
gint GuiDialogAbout::handleButtonPressEvent(GdkEventButton *e)
{
	this->hide ();
	return (0);
}


/*
 *  (virtual) delete_event_impl: catch the delete event
 */
gint GuiDialogAbout::delete_event_impl (GdkEventAny *e)
{
	this->hide ();
	return (0);
}


#ifdef HAVE_IMLIB

/*
 *  load_logo: load the logo from file into preview (and add preview to d_vBox)
 */
int GuiDialogAbout::loadLogo ()
{
	int		w, w3, h;
	guchar 		*pixelrow = NULL;
	MathRandom	*mRand = new MathRandom();

	gdk_imlib_init ();
	p_image = gdk_imlib_load_image (p_imageFile);
	w = p_image->rgb_width;
	h = p_image->rgb_height;

	d_preview.size (w, h);

	w3 = w*3;
	pixelrow = new guchar[w3];
	for (int i=0; i<h; i++)
		{
		memcpy (pixelrow, p_image->rgb_data+w3*i, w3);
		d_preview.draw_row (pixelrow, 0, i, w);
		}

	delete mRand;
	delete [] pixelrow;
	return (0);
}

#endif // HAVE_IMLIB

/*
int GlobalTrace::s_traceLevel = 255;
int main (int argc, char *argv[])
{
	Gtk_Main        gtkMain (&argc, &argv);
	GuiDialogAbout *testDialog;

	testDialog = new GuiDialogAbout ();
	testDialog->show ();
	gtkMain.run ();
}
*/

