#ifndef lint
static char SccsRegionId[] = "%W%  %G%";
#endif

/* Module:	Region.h
 * Purpose:	Define the structs for region drawing parameters
 */

struct regdrawRec {
  int visible;			/* draw-regions-in-display-window */
  int label;			/* label-regions-when-drawn */
  int label_xoff;		/* x text draw offset from point */
  int label_yoff;		/* y text draw offset from point */
  XFontStruct *fontstruct;	/* font used */
  int filled_label;		/* draw-text-with-background-filled */
  int label_height;		/* minimum vertical distance between labels */
  int pad;
  };

#if defined(REGION_MAIN)
struct regdrawRec regdraw;
#else
extern struct regdrawRec regdraw;
#endif

/* parameter record for regions given on a single line */
#define REG_LIMIT 32
struct reg_param {
  int type;
  int exclude;
  char *line;
  char connector;
  char not;
  };

/*
 * Jun 29 1989	Michael VanHilst  initial version
 *
 * Nov 30 1998	Paul Sydney  Declare regdrawRec type separately from structure
 */
