/***************************************************************************
                          rparameterdialog.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** RParameterDialog.h 1998/09/03 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RPARAMETERDIALOG_H
#define RPARAMETERDIALOG_H

#define DEF_PARAMDLG_WIDTH  360
#define DEF_PARAMDLG_HEIGHT 160


#include <qdialog.h>
#include <qlist.h>

#include "rlabel.h"
#include "rlineedit.h"

class QGridLayout;

class RParameterDialog : public QDialog
{
  Q_OBJECT
public:
  RParameterDialog(QWidget* _parent, 
                   const char* _title,
                   QPixmap& _pixmap);
  ~RParameterDialog();
  
  void addEntry(const char* _mes, const char* _val);
  void addEntry(const char* _mes, float _val);
  void addEntry(const char* _mes, int   _val);
  
  const char* getStringInput(int _index);
  int         getIntInput(int _index);
  float       getFloatInput(int _index);

private:
  QGridLayout* gl;
  
  QPushButton* bOk;
  QPushButton* bCancel;
  QPushButton* bHelp;

  QList<RLabel>    lLabel;
  QList<RLineEdit> eInput;
  
  int insertPos;
  
};


#endif

// EOF


