/***************************************************************************
                          rlayerwidget.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rlayerwidget.cpp 1998/08/24 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rlayerwidget.h"

#include <qkeycode.h>
#include <qmessagebox.h>
#include <qtoolbutton.h>
#include <qtooltip.h>

#include "rappwin.h"
#include "rgraphic.h"
#include "rconfig.h"
#include "rinputdialog.h"
#include "rlayoutdef.h"
#include "rlistboxitem.h"
#include "rlog.h"
#include "rprgdef.h"
#include "rtoolbar.h"
#include "rxpmlayer.h"
#include "ryesnodialog.h"

// Constructor:
//
// _rw: read/write
//
RLayerWidget::RLayerWidget(bool _rw,
                           QWidget* _parent, 
                           const char* _name, 
                           WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;

  //setFrameStyle(WinPanel|Raised);
  setFrameStyle(Panel|Raised);
  setLineWidth(1);

  // Create Tools:
  //
  bShowLayers = new QToolButton(this, "showlayers");
  bShowLayers->setPixmap(QPixmap(visiblelayer_xpm));
  QToolTip::add(bShowLayers, RMES(191));
  connect(bShowLayers, SIGNAL(clicked()), this, SLOT(showLayers()));
  
  bHideLayers = new QToolButton(this, "hidelayers");
  bHideLayers->setPixmap(QPixmap(hiddenlayer_xpm));
  QToolTip::add(bHideLayers, RMES(192));
  connect(bHideLayers, SIGNAL(clicked()), this, SLOT(hideLayers()));
  
  if(_rw) {
    bAddLayer = new QToolButton(this, "addlayer");
    bAddLayer->setPixmap(QPixmap(addlayer_xpm));
    QToolTip::add(bAddLayer, RMES(193));
    connect(bAddLayer, SIGNAL(clicked()), this, SLOT(addLayer()));
    
    bRemoveLayer = new QToolButton(this, "removelayer");
    bRemoveLayer->setPixmap(QPixmap(removelayer_xpm));
    QToolTip::add(bRemoveLayer, RMES(194));
    connect(bRemoveLayer, SIGNAL(clicked()), this, SLOT(removeLayer()));
  
    bRenameLayer = new QToolButton(this, "renamelayer");
    bRenameLayer->setPixmap(QPixmap(renamelayer_xpm));
    QToolTip::add(bRenameLayer, RMES(195));
    connect(bRenameLayer, SIGNAL(clicked()), this, SLOT(renameLayer()));

    bRemoveEmptyLayers = new QToolButton(this, "removeemptylayers");
    bRemoveEmptyLayers->setPixmap(QPixmap(removeemptylayers_xpm));
    QToolTip::add(bRemoveEmptyLayers, RMES(196));
    connect(bRemoveEmptyLayers, SIGNAL(clicked()), this, SLOT(removeEmptyLayers()));
  }
  else {
    bAddLayer=0;
    bRemoveLayer=0;
    bRenameLayer=0;
    bRemoveEmptyLayers=0;
  }

  fSep1 = new QFrame(this, "sep1");
  fSep1->setFrameStyle(HLine|Sunken);
                             
  // Create the Layer-List:
  //
  layerList = new QListBox(this, "layerlist");
  //layerList->setAutoUpdate(true);
  layerList->setDragSelect(false);
  layerList->setMultiSelection(false);
  layerList->setSmoothScrolling(true);
  QToolTip::add(layerList, RMES(197));

  // Pixmaps for Layerlist (Eyes)
  //
  pxmVisible = new QPixmap(visiblelayer_xpm);
  pxmHidden  = new QPixmap(hiddenlayer_xpm);

  // Connect signal "selected" with slot "switchLayer"
  //   Whenever a layer was selected the function
  //   "switchLayer" gets called 
  //
  connect(layerList, SIGNAL(selected(int)),
          this     , SLOT(switchLayer(int)));

  // Connect signal "highlight" with slot "selectLayer"
  //   Whenever a layer was highlighted the function
  //   "selectLayer" gets called 
  //
  connect(layerList, SIGNAL(highlighted(int)),
          this     , SLOT(selectLayer(int)));
}



// Destructor:
//
RLayerWidget::~RLayerWidget()
{

}



// Show layer widget and all widgets in it:
//
void 
RLayerWidget::show()
{
  RWidget::show();
}



// Resize event:
//
void 
RLayerWidget::resizeEvent(QResizeEvent* _ev)
{
  RWidget::resizeEvent(_ev);
  resizeChildren();
}



// Resize the children:
//
void
RLayerWidget::resizeChildren()
{
  int y=2;

  if(layerList) {
    layerList->setGeometry(0, 0,
                           width()-DEF_BSIZE0-3, height());
  }

  if(bShowLayers) {
    bShowLayers->setGeometry(width()-DEF_BSIZE0-2, y,
                             DEF_BSIZE0, DEF_BSIZE0);
    y+=DEF_BSIZE0;
  }

  if(bHideLayers) {
    bHideLayers->setGeometry(width()-DEF_BSIZE0-2, y,
                             DEF_BSIZE0, DEF_BSIZE0);
    y+=DEF_BSIZE0;
  }

  if(bAddLayer) {
    bAddLayer->setGeometry(width()-DEF_BSIZE0-2, y,
                           DEF_BSIZE0, DEF_BSIZE0);
    y+=DEF_BSIZE0;
  }

  if(bRemoveLayer) {
    bRemoveLayer->setGeometry(width()-DEF_BSIZE0-2, y,
                              DEF_BSIZE0, DEF_BSIZE0);
    y+=DEF_BSIZE0;
  }

  if(bRenameLayer) {
    bRenameLayer->setGeometry(width()-DEF_BSIZE0-2, y,
                              DEF_BSIZE0, DEF_BSIZE0);
    y+=DEF_BSIZE0;
  }

  if(bRemoveEmptyLayers) {
    bRemoveEmptyLayers->setGeometry(width()-DEF_BSIZE0-2, y,
                                    DEF_BSIZE0, DEF_BSIZE0);
    y+=DEF_BSIZE0;
  }

  if(fSep1) {
    fSep1->setGeometry(width()-DEF_BSIZE0-2, y,
                       DEF_BSIZE0, 6);
  }
}


// Give a size hint:
//
QSize 
RLayerWidget::sizeHint() const
{
  int listWidth = layerList->sizeHint().width()+3;
  if(listWidth<DEF_MINLAYERLISTWIDTH) listWidth=DEF_MINLAYERLISTWIDTH;
  if(listWidth>DEF_MAXLAYERLISTWIDTH) listWidth=DEF_MAXLAYERLISTWIDTH;
  QSize ret(listWidth+DEF_BSIZE0+3, 
            layerList->sizeHint().height()+6);
  return ret;
}



// Set the pointer to a graphic and update the layers:
//
void 
RLayerWidget::setGraphic(RGraphic* _graphic) 
{ 
  graphic=_graphic; 
  updateLayerList();
}



// Update the layerlist:
//
void 
RLayerWidget::updateLayerList()
{
  if(layerList) {
  
    layerList->clear();
    
    if(graphic) {
      int     i;
      RLayer* lay;           // Pointer to a layer in the graphic
      RListBoxItem* newItem; // Temp pointer to create a new item
      
      RLOG("\nupdateLayerList");
      RLOG("\nNumber of layers: ");
      RLOG(graphic->countLayers());
  
      //layerList->setAutoUpdate(false);
  
      for(i=0; i<graphic->countLayers(); ++i) {
        lay = graphic->getLayer(i);
        
        if(lay->getFlag(Y_USED) &&
           lay->getName()) {
           
          if(lay->getFlag(Y_VISIBLE)) {
            newItem = new RListBoxItem(lay->getName(), *pxmVisible);
          }
          else {
            newItem = new RListBoxItem(lay->getName(), *pxmHidden);
          }
          layerList->inSort(newItem);
	  
     	    RLOG("\nRLayerWidget::updateLayerList: Layer inserted: ");
      	  RLOG(lay->getName());
        }
      }
      //layerList->setAutoUpdate(true);
    }
    layerList->repaint();
  }
}



// Switch a layer on / off:
//
void
RLayerWidget::switchLayer(int _index) 
{ 
  if(_index>=0) {
    if(layerList && graphic) {
    
      emit layerSwitched(layerList->text(_index)); 
      
      RListBoxItem* newItem;
      if(graphic->isLayerVisible(layerList->text(_index))) {
        newItem = new RListBoxItem(layerList->text(_index), *pxmVisible);
      }
      else {
        newItem = new RListBoxItem(layerList->text(_index), *pxmHidden);
      }
      layerList->changeItem(newItem, _index);

      graphic->repaint();
    }
  }
}



// Select a layer by index:
//
void
RLayerWidget::selectLayer(int _index) 
{ 
  if(_index>=0) {
    if(layerList && graphic) {
      emit layerSelected(layerList->text(_index).latin1()); 
    }
  }
}



// Select a layer by name:
//
void
RLayerWidget::selectLayer(const char* _name) 
{ 
  if(_name) {
    if(layerList && graphic) {
      int num=0;
      for(int i=0; i<(int)layerList->count(); ++i) {
        if(!strcmp(layerList->text(i).latin1(), _name)) {
          num=i;
          break;
        }
      }
      layerList->setCurrentItem(num);
      //selectLayer(num);
    }
  }
}



// Add a Layer:
//
void
RLayerWidget::addLayer()
{
  if(graphic) {
    // Type a name for the new Layer:
    //
    RInputDialog idlg(RMES(198),
                      255, 0, this, "idlg");
    if(idlg.exec()) {
      const char* newLayer = idlg.getInput();
  
      if(newLayer && layerList) {
        QString curItem = layerList->text(layerList->currentItem()).latin1();
        
        graphic->addLayer(newLayer);
        selectLayer(curItem.latin1());
	
	// This shouldn't be necessary, but it is since Qt Ver 2.00:
	//
	updateLayerList();
      }
    }
  }
}




// Remove a Layer:
//
void
RLayerWidget::removeLayer()
{
  const char* remLayer=0;
  remLayer = layerList->text(layerList->currentItem()).latin1();

  if(graphic && layerList && remLayer) {
    int onLayer = graphic->countElementsOnLayer(remLayer);
    char mes[512];

    if(onLayer==1) {
      // There is one object\non Layer 'nnn'.\n\nDo you really want to delete it?
      //
      sprintf(mes,
              "%s %s %s",
              RMES(199), remLayer, RMES(200));
    }
    else {
      // There are %d objects\non Layer '%s'.\n\nDo you really want to delete them?
      //
      sprintf(mes, 
              "%s %d %s%s%s",
              RMES(201), onLayer, RMES(202), remLayer, RMES(203));
    }
  
    RYesNoDialog ydlg(mes,
                      RMES(168),
                      RMES(169),
                      this, 
                      "ydlg");
                      
    if(onLayer==0 || ydlg.exec()) {
      graphic->removeLayer(remLayer, true);
      graphic->repaint();
    }
  }
}



// Rename a Layer:
//
void
RLayerWidget::renameLayer()
{
  const char* renLayer=0;
  renLayer = layerList->text(layerList->currentItem()).latin1();

  if(graphic && layerList && renLayer) {
    char mes[256];

    sprintf(mes, 
            "%s '%s':",
            RMES(204), renLayer);

    RInputDialog idlg(mes, 255, renLayer, this, "idlg");
    if(idlg.exec()) {
      const char* newLayer = idlg.getInput();
  
      graphic->renameLayer(renLayer, newLayer);
    }
  }
}



// Show all Layers:
//
void
RLayerWidget::showLayers()
{
  showHideAllLayers(true);
}



// Hide all Layers:
//
void
RLayerWidget::hideLayers()
{
  showHideAllLayers(false);
}



// Show (_show=true) or hide (_show=false) all Layers:
//
void 
RLayerWidget::showHideAllLayers(bool _show)
{
  if(layerList && graphic) {
    int i;                  // counter
    bool found=false;       // found layer to switch
    RListBoxItem* newItem;  // pointer for creation of new items
    QString itemText;       // text of current item
    
    for(i=0; i<(int)layerList->count(); ++i) {
      itemText=layerList->text(i).latin1();
      if(graphic->isLayerVisible(itemText.latin1())!=_show) {
        found=true;
        emit layerSwitched(itemText.latin1()); 
        newItem = new RListBoxItem(itemText.latin1(), 
                                   _show ? *pxmVisible : *pxmHidden);
        layerList->changeItem(newItem, i);
      }
    }
    if(found) graphic->repaint();
  }
}



// Remove all layers without elements on it:
//
void 
RLayerWidget::removeEmptyLayers()
{
  if(graphic) {
    graphic->removeEmptyLayers();
  }
}



// EOF


