/***************************************************************************
                          rfilegbx.h  -  description
                             -------------------
    begin                : Tue Nov 9 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : mustun@ribbonsoft.com
 ***************************************************************************/


#ifndef RFILEGBX_H
#define RFILEGBX_H

#include "rfilebase.h"

#include "rgraphic.h"

#define GER_MAXTOOLS   1024

/**Offers Gerber support.
  *@author Andreas Mustun
  */

class RFileGbx : public RFileBase  {
public:
	RFileGbx(const char* _name, RGraphic* _graphic);
	~RFileGbx();
	
	bool load();
	
	bool readFromBuffer();
	
	bool save();
	
private:
  float  preX,                 // previous X
         curX,                 // current X
         preY,                 // previous Y
         curY;                 // current Y

  bool   toolIsDown;           // Is the tool currently down (=true)

  struct toolStruct {          // Structur for tools
    float x;                   // x-measure of the tool
    float y;                   // y                         _
    char  shape;               // Shape: 'c' = circular    (_)
                               //                           _____
                               //        'o' = oblong      (_____)
                               //                           _____
                               //        'r' = rectangular |_____|
  };

  struct toolStruct gerTool[GER_MAXTOOLS];  // The tools

  struct toolStruct curTool;   // Current gerber tool

  RGraphic* graphic;
  int       numElements;
};

#endif


