/***************************************************************************
                          rfile.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rfile.cpp 1998/09/25 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rfile.h"

#include <qfileinfo.h>

#include "rconfig.h"
#include "rlog.h"
#include "ryesnodialog.h"


// Get nick name of a file (short file name)
//
// copies file _source to file _dest
//
// _what: What is this file? (Machinegenerator, ...) Used for overwrite warning
//
// return: true: successful
//         false: error
//
bool 
fileCopy(QString _source, QString _dest, const char* _what, QWidget* _parent)
{
  bool ret=false;
  
  QFile sourceFile(_source.data());
  QFile destFile(_dest.data());

  if(!destFile.exists() || 
     fileOverwriteWarning(_dest.data(), _what, _parent)) {
      
    if(sourceFile.open(IO_ReadOnly)) {
      if(destFile.open(IO_WriteOnly)) {
    
        char* buffer;
        buffer= new char[sourceFile.size()+1];
      
        sourceFile.readBlock(buffer, sourceFile.size());
        destFile.writeBlock(buffer, sourceFile.size());
               
        destFile.close();
        ret=true;
      }
      sourceFile.close();
    }
  }
  
  return ret;
}



// Overwrite-Dialog:
//
// _file: filename
// _what: e.g.: "Machine-Generator 'name' does already..."
//               -> _what = Machine-Generator
// _ext:  show extensions
//
bool
fileOverwriteWarning(const char* _file, const char* _what, QWidget* _parent)
{
  if(_file && _what) {
    // Overwrite?
    //
    QString mes;
    mes.sprintf("%s\n'%s'\n%s\n"
                "%s\n",
                _what, _file, RMES(176), RMES(177));
    RYesNoDialog overDlg(mes.data(), 
                         RMES(168), RMES(169),
                         _parent);
    if(overDlg.exec()) {
      return true;
    }
  }
  
  return false;
}


// Delete file _file:
//
// _what: e.g.: "Machine-Generator 'name' does already..."
//               -> _what = Machine-Generator
//
bool 
fileDelete(const char* _file, const char* _what, QWidget* _parent)
{
  if(_file && _what) {
    QFile file(_file);
    if(file.exists()) {
      QString mes;
      mes.sprintf("%s %s\n'%s'?",
                  RMES(178), _what, _file);
      RYesNoDialog overDlg(mes.data(), 
                           RMES(168), RMES(169),
                           _parent);
      if(overDlg.exec()) {
        QFile(_file).remove();
        return true;
      }
    }
  }
  return false;
}



// Check Format of file _file:
//   Format must be _format and version must be _version
//
bool     
fileCheckFormat(const char* _file, 
                const char* _format, 
                const char* _version)
{
  bool ret=true;
  char value[128];
  
  RLOG("\nfileCheckFormat");
  RLOG("\nFile: ");
  RLOG(_file);
  RLOG("\nFormat: ");
  RLOG(_format);
  RLOG("\nVersion: ");
  RLOG(_version);
  
  // Check Format type:
  //
  if(_format) {
    fileGetFormatInfo(_file, "Format", value, 127);
    
    RLOG("\nRead Format: ");
    RLOG(value);
    
    if(stricmp(value, _format)) {
      ret=false;
    }
  }
  
  // Check Format version:
  //
  if(_version) {
    fileGetFormatInfo(_file, "Version", value, 127);
    
    RLOG("\nRead Version: ");
    RLOG(value);
    
    if(stricmp(value, _version)) {
      ret=false;
    }
  }
  
  RLOG("\nReturn: ");
  RLOG(ret);

  return ret;
}




// Get Format info of file _file. Info name: _name
//
void
fileGetFormatInfo(const char* _file, const char* _name, char* _value, int _maxLength)
{
  bool done=false;     // Finished?
    
  RLOG("\nfileGetFormatInfo");
  RLOG("\nFile: ");
  RLOG(_file);
  RLOG("\nName: ");
  if(_name) RLOG(_name);
  RLOG("\nMax. Length: ");
  RLOG(_maxLength);
  
  if(_file && _name) {
    QFile file(_file);
    if(file.exists()) {
      FILE* fp=fopen(_file, "rt");
    
      if(fp) {
        
        // Check Format:
        //
        char  fLine[128];    // The whole line:  "# Format:     CAM Expert Font"
        char* fWalker;       // Walk through line
        char  fName[128];    // Info name:       "Format"
        char  fValue[128];   // Info value:      "CAM Expert Font"
        char  fDum1[128];    // Dummy for length measuring
        char  fDum2[128];    // Dummy for length measuring
        
        while(!done && !feof(fp)) {
          
          fLine[0]='\0';
          fName[0]='\0';
          fValue[0]='\0';
          fDum1[0]='\0';
          fDum2[0]='\0';

          // Read whole line:
          //
          fscanf(fp, "%127[^\n]%*[\n]", fLine);
          fWalker=fLine;
          
          RLOG("\nWhole Line: ");
          RLOG(fWalker);
          
          // Scan #:
          //
          if(fWalker[0]=='#') {
            
            // Scan Name of current format info:
            //
            ++fWalker;
            sscanf(fWalker, "%127[ ]%127[^: \n]%127[ :]", fDum1, fName, fDum2);
            
            RLOG("\nName: ");
            RLOG(fName);
            RLOG("\nDum1: "); 
            RLOG(fDum1);
            RLOG("\nDum2: "); 
            RLOG(fDum2); 
            
            // Overjump read strings:
            //
            fWalker+=strlen(fDum1);   // Overjump space
            fWalker+=strlen(fName);   // Overjump name
            fWalker+=strlen(fDum2);   // Overjump colon and space
            
            // Scan Value of current format info:
            //
            sscanf(fWalker, "%127[^\n]", fValue);
            if(fValue[strlen(fValue)-1]<32) fValue[strlen(fValue)-1]='\0';
            
            RLOG("\nValue: ");
            RLOG(fValue);
            
            if(!stricmp(fName, _name)) {
              strncpy(_value, fValue, _maxLength);
              done=true;
              
              RLOG("\nValue: ");
              RLOG(_value);

            }
          }
        }
        
        fclose(fp);
      } // -> if(fp)
      
    }
  }
}



/**
 * Searchs a file with a given subdir and a file name.
 */
QString
fileSearchFile(QString _subdir, QString _name)
{
  QString ret = RCONFIG->getPrgDir().path()+"/"+_subdir+"/"+_name;
  if(QFileInfo(ret).exists()) return ret;

#ifndef DEF_WINDOWS
  // Test /usr/share/<proj>/...:
  ret = QString("/usr/share/")+DEF_APPNAME_L+"/"+_subdir+"/"+_name;
  if(QFileInfo(ret).exists()) return ret;

  // Read from ~/.<proj>/fonts:
  ret = RCONFIG->getConfigDir().path()+"/"+_subdir+"/"+_name;
  if(QFileInfo(ret).exists()) return ret;
#endif

  ret="";
  return ret;
}


/**
 * Searchs a subdir.
 */
QString
fileSearchSubdir(QString _subdir)
{
  QString ret = RCONFIG->getPrgDir().path()+"/"+_subdir;
  if(QFileInfo(ret).exists()) return ret;

#ifndef DEF_WINDOWS
  // Test /usr/share/<proj>/...:
  ret = QString("/usr/share/")+DEF_APPNAME_L+"/"+_subdir;
  if(QFileInfo(ret).exists()) return ret;

  // Read from ~/.<proj>/fonts:
  ret = RCONFIG->getConfigDir().path()+"/"+_subdir;
  if(QFileInfo(ret).exists()) return ret;
#endif

  ret="";
  return ret;
}



// EOF



