/***************************************************************************
                          rconfig.h  -  description
                             -------------------
    begin                : Sun Sep 12 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RCONFIG_H
#define RCONFIG_H

// Used for access to the configuration file e.g.: RCONFIG->getSetting("Language:Language")
//
#define RCONFIG RConfig::getConfig()

// Used for access to messages e.g.: RMES(123)
//
#define RMES    RCONFIG->getMessage

#include "qdir.h"

#include "rprgdef.h"
#include "rsettings.h"

class RConfig : public RSettings
{

protected:
  RConfig();

  void ini();

public:
  ~RConfig();

  static  RConfig* getConfig();

  /** Sets verbose mode. */
  void    setVerbose(bool _on) { verbose=_on; }
  /** Gets verbose mode. */
  bool    getVerbose() const { return verbose; }

  /** Sets directory of the local configuration file. */
  void    setConfigDir(QDir _configDir) { configDir=_configDir; }
  /** Gets directory of the local configuration file. */
  QDir    getConfigDir() const { return configDir; }

  /** Sets directory of the program. */
  void    setPrgDir(QDir _prgDir) { prgDir=_prgDir; }
  /** Gets directory of the program. */
  QDir    getPrgDir() const { return prgDir; }

  bool    createConfigFile( bool overwrite=false );
  bool    readConfigFile();

  void    createLanguageList();
  bool    readCxlFile();

  const char* getMessage(int num) const;

  QString getLanguageSign( QString _languageName );
  QString getLanguageName( QString _languageSign );

  int     getLanguageNum();
  QString getLanguage(int _index);


  QString searchFile(const char* _relPath) const;

private:
  static RConfig* theOneAndOnlyConfig;

  /** Verbose mode. */
  bool   verbose;

  QDir   prgDir;
  QDir   configDir;

  QString mes[DEF_MESSAGES];  // The messages (MES[#])

  struct languageStruct {      // Struct for a language
    QString name;              // Name of Language ("English")
    QString sign;              // Sign of Language ("en")
  };
  QList<languageStruct> languageList;

public:
  // Some public variables provided for faster access:
  float cadDimensionTextHeight;
  bool  cadDimensionTextAutoScale;
  float cadDimensionTextDistance;
  float cadDimensionOverLength;
  float cadDimensionArrowLength;

};


#endif

// EOF




