/***************************************************************************
                          raction.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

#include <qapplication.h>
#include <qevent.h>

#include "rappwin.h"
#include "raction.h"
#include "rgraphic.h"

/*! \class RAction
    \brief Basis class for actions (RActDraw, RActEdit, RActTag, RActZoom)

    \author Andrew Mustun
*/

/*! Constructor
*/
RAction::RAction()
{

}



/*! Destructor
*/
RAction::~RAction()
{
}


/*! Gets the current document object (graphic)
    \return pointer to current loaded document or 0 if no doc is open
*/
RGraphic* 
RAction::currentDoc()
{
  return RAppWin::getRAppWin()->currentDoc();
}



/*! Gets the current output document (graphic)
    \return Pointer to current output document (graphic)
*/
RGraphic* 
RAction::currentOut()
{
  return RAppWin::getRAppWin()->currentOut();
}



/*! Gets the snapper object
    \return Pointer to snapper class
*/
RSnap*
RAction::snapper()
{
  return RAppWin::getRAppWin()->currentDoc()->snapper();
}



/*! Gets the status panel object
    \return Pointer to status panel
*/
RStatusPanel*
RAction::statusPanel()
{
  return RAppWin::getRAppWin()->getStatusPanel();
}



/*! Gets the input panel object
    \return Pointer to input panel
*/
RInputPanel*
RAction::inputPanel()
{           	
  return RAppWin::getRAppWin()->getInputPanel();
}



// EOF


