/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

	Starting point for a particle system

    Copyright (c) 1997-1999 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PART_HEAD_H_
#define INCLUDE_PART_HEAD_H_

#include "Base/GemBase.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS

	part_head
    
	Starting point for a particle system

DESCRIPTION

-----------------------------------------------------------------*/
class GEM_EXTERN part_head : public GemBase
{
    CPPEXTERN_HEADER(part_head, GemBase)

    public:

	    //////////
	    // Constructor
    	part_head(t_floatarg priority);
    	
    	//////////
    	virtual void 	render(GemState *state);

    protected:
    	
    	//////////
    	// Destructor
    	virtual ~part_head();

		//////////
		// The particle group
		int				m_particleGroup;
};

#endif	// for header file
