// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.awt.*;
import java.util.*;

public class Alert extends Dialog {

    Button okButton = new Button("OK");

    public Alert(Frame parent, String msg)
    {
	this(parent, "Error", msg, null);
    }

    public Alert(Frame parent, String title, String msg)
    {
	this(parent, title, msg, null);
    }

    public Alert(Frame parent, String title, String msg, Image icon)
    {
	super(parent, title, true);

	setResizable(false);
	add("Center", new Label(msg));

	Panel		buttonPanel = new Panel();
	buttonPanel.setLayout(new BorderLayout());
	buttonPanel.add("East", okButton);

	add("West", new Icon(icon, 32, 32));
	add("South", buttonPanel);
	pack();
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == okButton && evt.id == Event.ACTION_EVENT) {
	    hide();
	    return true;
	} else {
	    return false;
	}
    }
}
