/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 Ondrejicka Stefan			   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>

cfg_param cfg;

gint _atoi(str) 
gchar *str;
{
	gchar *__eptr__;
	long int rv;

	rv = strtol(str , (char **) &__eptr__ , 0);
	if (*__eptr__ != '\0') errno = ERANGE;
	else errno = 0;

	return (gint)rv;
}

gfloat _atof(str) 
char *str;
{
	gchar *__eptr__;
	double rv;

	rv = strtod(str , (char **) &__eptr__);
	if (*__eptr__ != '\0') errno = ERANGE;
	else errno = 0;

	return (gfloat)rv;
}

char *simplify_path(path)
char *path;
{
	char *p = path;
	char res[2048];
	int l;

	res[0] = '\0';
	while (*p)
	{
		p += strspn(p , "/");
		l = strcspn(p , "/");	

		if (strncmp(p , "." , l))
		{
			if (!strncmp(p , ".." , l))
			{
				char *sl = strrchr(res , '/');

				if (sl)
					*sl = '\0';
			}
			else
			{
				strcat(res , "/");
				strncat(res , p , l);
			}
		}
		p +=l;
	}
	if (!res[0])
		strcpy(path , "/");
	else
		strcpy(path , res);

	return path;	
}

void cfg_usage(prg)
gchar *prg;
{
	printf(gettext("Usage:  %s  [options] [any number of pictures]\n%s-%s\n") ,prg ,
		PACKAGE , VERSION);

	printf(gettext("\t-v                    - print version number and exit\n"));
	printf(gettext("\t-h                    - print this help message and exit\n"));
	printf(gettext("\t-setup                - start setup window\n"));
	printf(gettext("\t-scenario $file       - fetch parameters from file $file\n"));
	printf(gettext("\t-mode $type           - set picture rendering mode, mode is\n"
	       "\t                        one of following:\n"
	       "\t                        : tile\n"
	       "\t                        : mirror\n"
	       "\t                        : center\n"
	       "\t                        : maximize\n"
	       "\t                        : smart\n"));
	printf(gettext("\t-efect $nr            - efect type for changing pictures [0-%d]\n") , NUM_EFECTS);
        printf(gettext("\t-bg                   - set default background color 1\n"));
        printf(gettext("\t-bg2                  - set default background color 2\n"));
	printf(gettext("\t-rand_colors          - randomize background colors\n"));
	printf(gettext("\t-shader $nr           - set background color shading efect\n"
		       "\t                        type [0-%d]\n"), NUM_SHADERS);
	printf(gettext("\t-interval             - time between picture changes\n"));
	printf(gettext("\t-max_grow             - maximal growing ratio of picture in\n"
		       "\t                        smart mode\n"));
	printf(gettext("\t-max_size             - maximal size of picture in %% of screen size\n"
		       "\t                        used in smart mode, acceptable value 10-100\n"));
	printf(gettext("\t-randomize            - randomize picture order\n"));
	printf(gettext("\t-screensaver          - act as screensaver\n"));
	printf(gettext("\t-xscreensaver         - act as xscreensaver client\n"));
	printf(gettext("\t-speed $nr            - speed ratio for picture changing efects\n"
		       "\t                        (lower is faster)\n"));
	printf(gettext("\t-blank                - show blank screen, when can't load picture\n"));
	printf(gettext("\t-cycle_blank          - when pictures not present cycle with blanking\n"
		       "\t                        screen (optionaly with shading)\n"));
	printf(gettext("\t-R                    - recurse through directory\n"));
	printf(gettext("\t-pattern $ptrn        - wildcard pattern for picture selection in\n"
		       "\t                        recursion trought directories\n"));
	printf(gettext("\t-inwindow             - run in own window not on root\n"));
	printf(gettext("\t-windowid $id         - run in existing window\n"));
	printf(gettext("\t-run                  - start run after setup window is popped up\n"
		       "\t                        (have efect only when used with -setup option)\n"));
	exit(1);
}

void cfg_default()
{
	cfg.properties.max_grow = default_max_grow;
	cfg.properties.interval = default_interval;
	cfg.properties.max_size = default_max_size;
	cfg.properties.type = default_type;
	cfg.properties.efect = default_efect;
	cfg.properties.shade = default_shader;
	cfg.properties.rand_colors = FALSE;
	cfg.speed = default_speed;
	cfg.pics = NULL;
	cfg.num_pics = 0;
	gdk_color_parse("#000000" , &cfg.properties.background);
	gdk_color_parse("#ffffff" , &cfg.properties.background2);
	cfg.screensaver = FALSE;
	cfg.xscreensaver = FALSE;
	cfg.blank = FALSE;
	cfg.setup = FALSE;
	cfg.scenario = NULL;
	cfg.recurse = FALSE;
	cfg.inwindow = FALSE;
	cfg.windowid = 0;
	cfg.runit = FALSE;
	cfg.pattern = NULL;
	cfg.cycle_blank = FALSE;
}

static shtype cfg_get_mode(str)
gchar *str;
{
	if (!strcasecmp("tile" , str))
		return TILE;
	else if (!strcasecmp("mirror" , str))
		return MIRROR;
	else if (!strcasecmp("center" , str))
		return CENTER;
	else if (!strcasecmp("maximize" , str))
		return MAXIMIZE;
	else if (!strcasecmp("smart" , str)) 
		return MAX_ASP_RATIO_CENTER;
	else
	{
		printf(gettext("unknown rendering type : %s\n") , str);
		return default_type;
	}
}

static gchar* cfg_get_mode_str(type)
shtype type;
{
	switch(type)
	{
		case TILE: return "tile";
		case MIRROR: return "mirror";
		case CENTER: return "center";
		case MAXIMIZE: return "maximize";
		case MAX_ASP_RATIO_CENTER: return "smart";
		default: return gettext("bug in chbg - contact autor");
	}
}

gint cfg_cmdln(argc , argv)
guint argc;
gchar **argv;
{
	gint i;
	char *cwd = NULL;

	for(i = 1; i < argc ; i++)
	{
		if (!strcasecmp("-mode" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.properties.type = cfg_get_mode(argv[i]);
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-type");
				return -1;
			}
		}
		else if (!strcasecmp("-bg" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				if (!gdk_color_parse(argv[i] , &cfg.properties.background))
				{
					printf(gettext("unknown color: %s\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-bg");
				return -1;
			}
		}
		else if (!strcasecmp("-bg2" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				if (!gdk_color_parse(argv[i] , &cfg.properties.background2))
				{
					printf(gettext("unknown color: %s\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-bg2");
				return -1;
			}
		}
		else if (!strcasecmp("-max_grow" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.properties.max_grow = _atof(argv[i]);
				if (errno == ERANGE || (cfg.properties.max_grow <= (gfloat)0.0))
				{
					printf(gettext("bad grow value: %s , (positive float number required)\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-max_grow");
				return -1;
			}
		}
		else if (!strcasecmp("-interval" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.properties.interval = _atof(argv[i]);
				if (errno == ERANGE)
				{
					printf(gettext("bad float value: %s\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-interval");
				return -1;
			}
		}
		else if (!strcasecmp("-max_size" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.properties.max_size = _atoi(argv[i]);
				if (errno == ERANGE || cfg.properties.max_size < 10 || cfg.properties.max_size > 100)
				{
					printf(gettext("bad max_size value: %s , (10 - 100 required)\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-max_size");
				return -1;
			}
		}
		else if (!strcasecmp("-speed" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.speed = _atoi(argv[i]);
				if (errno == ERANGE)
				{
					printf(gettext("bad speed value: %s\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-speed");
				return -1;
			}
		}
		else if (!strcasecmp("-efect" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.properties.efect = _atoi(argv[i]);
				if (errno == ERANGE || cfg.properties.efect > NUM_EFECTS)
				{
					printf(gettext("bad efect value: %s , (0 - %d required)\n") , argv[i] , NUM_EFECTS);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-efect");
				return -1;
			}
		}
		else if (!strcasecmp("-shader" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.properties.shade = _atoi(argv[i]);
				if (errno == ERANGE || cfg.properties.shade > NUM_SHADERS)
				{
					printf(gettext("bad shader value: %s , (0 - %d required)\n") , argv[i] , NUM_SHADERS);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-shader");
				return -1;
			}
		}
		else if (!strcasecmp("-windowid" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.windowid = _atoi(argv[i]);
				if (errno == ERANGE)
				{
					printf(gettext("bad windowid: %s\n") , argv[i]);
					return -1;
				}
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-windowid");
				return -1;
			}
		}
		else if (!strcasecmp("-scenario" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.scenario = g_strdup(argv[i]);
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-scenario");
				return -1;
			}
		}
		else if (!strcasecmp("-R" , argv[i]))
		{
			cfg.recurse = TRUE;
		}
		else if (!strcasecmp("-screensaver" , argv[i]))
		{
			cfg.screensaver = TRUE;
		}
		else if (!strcasecmp("-xscreensaver" , argv[i]))
		{
			cfg.xscreensaver = TRUE;
		}
		else if (!strcasecmp("-blank" , argv[i]))
		{
			cfg.blank = TRUE;
		}
		else if (!strcasecmp("-setup" , argv[i]))
		{
			cfg.setup = TRUE;
		}
		else if (!strcasecmp("-randomize" , argv[i]))
		{
			cfg.randomize = TRUE;
		}
		else if (!strcasecmp("-inwindow" , argv[i]))
		{
			cfg.inwindow = TRUE;
		}
		else if (!strcasecmp("-run" , argv[i]))
		{
			cfg.runit = TRUE;
		}
		else if (!strcasecmp("-cycle_blank" , argv[i]))
		{
			cfg.cycle_blank = TRUE;
		}
		else if (!strcasecmp("-rand_colors" , argv[i]))
		{
			cfg.properties.rand_colors = TRUE;
		}
		else if (!strcasecmp("-h" , argv[i]))
		{
			cfg_usage(PACKAGE);
		}
		else if (!strcasecmp("-v" , argv[i]))
		{
			printf("%s-%s\n" , PACKAGE , VERSION);
			exit(1);
		}
		else if (!strcasecmp("-pattern" , argv[i]))
		{
			i++;
			if (i < argc)
			{
				cfg.pattern = g_slist_append(cfg.pattern, g_strdup(argv[i]));
			}
			else
			{
				printf(gettext("missing parameter for %s option\n") , "-pattern");
				return -1;
			}
		}
		else if (*(argv[i]) != '-')
		{			
			picentry *pe;

			pe = g_malloc(sizeof(picentry));
			pe->prop = NULL;
			if (*argv[i] == '/')
				pe->name = g_strdup(argv[i]);
			else
			{
				if (!cwd)
					cwd = getcwd(NULL, 0);
				pe->name = g_strconcat(cwd , "/" , argv[i] , NULL);
			}
			simplify_path(pe->name);
			cfg.pics = g_slist_append(cfg.pics , (gpointer)pe);
			cfg.num_pics ++;
		}
		else
		{
			printf(gettext("unknown option : %s\n") , argv[i]);
			return -1;
		}
	}

	if (cwd) free(cwd);
	return 0;
}

int cfg_scenario(scenario)
gchar *scenario;
{
	FILE *f;
	char line[PATH_MAX];
	picentry *pe = NULL;
	shtype typev;
	gfloat max_growv;
	gfloat intervalv;
	guint max_sizev;
	guint efectv;
	

	if (!(f = fopen(scenario , "r")))
	{
		perror(scenario);
		return -1;
	}

	while(fgets(line , sizeof(line) , f))
	{
		gchar *lns;

		for(lns = line + strlen(line) - 1; lns >= line && isspace(*lns) ; lns--) 
			*lns = '\0';
                for(lns = line ; *lns && isspace(*lns) ; lns++);

		if (lns[0] == '#') continue;
		if (!*lns) continue;

		if (!strncasecmp(lns , "RenderingMode:" , 14))
		{
			lns += 14;
			for( ; *lns && isspace(*lns) ; lns++);
			typev = cfg_get_mode(lns);
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));

				pe->prop->type = typev;
			}
			else
				cfg.properties.type = typev;
		}
		else if (!strncasecmp(lns , "Interval:" , 9))
		{
			lns += 9;
			for( ; *lns && isspace(*lns) ; lns++);
			intervalv = _atof(lns);
			if (errno == ERANGE)
			{
				printf(gettext("bad interval value: %s , (float required)\n") , lns);
				intervalv = default_interval;
			}
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));

				pe->prop->interval = intervalv;
			}
			else
				cfg.properties.interval = intervalv;
		}
		else if (!strncasecmp(lns , "MaxSize:" , 8))
		{
			lns += 8;
			for( ; *lns && isspace(*lns) ; lns++);
			max_sizev = _atoi(lns);
			if (errno == ERANGE || max_sizev < 10 || max_sizev > 100)
			{
				printf(gettext("bad max_size value: %s , (10 - 100 required)\n") , lns);
				max_sizev = default_max_size;
			}
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));

				pe->prop->max_size = max_sizev;
			}
			else
				cfg.properties.max_size = max_sizev;
		}
		else if (!strncasecmp(lns , "Speed:" , 6))
		{
			lns += 6;
			for( ; *lns && isspace(*lns) ; lns++);
			cfg.speed = _atoi(lns);
			if (errno == ERANGE)
			{
				printf(gettext("bad speed value: %s\n") , lns);
				cfg.speed = default_max_size;
			}
		}
		else if (!strncasecmp(lns , "Efect:" , 6))
		{
			lns += 6;
			for( ; *lns && isspace(*lns) ; lns++);
			efectv = _atof(lns);
			if (errno == ERANGE)
			{
				printf(gettext("bad efect value: %s , (0 - %d required)\n") , lns , NUM_EFECTS);
				efectv = default_efect;
			}
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));

				pe->prop->efect = efectv;
			}
			else
				cfg.properties.efect = efectv;
		}
		else if (!strncasecmp(lns , "Shader:" , 7))
		{
			lns += 7;
			for( ; *lns && isspace(*lns) ; lns++);
			efectv = _atof(lns);
			if (errno == ERANGE)
			{
				printf(gettext("bad shader value: %s , (0 - %d required)\n") , lns , NUM_SHADERS);
				efectv = default_shader;
			}
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));

				pe->prop->shade = efectv;
			}
			else

			/* Next line modified				*/
			/* wrong was :  cfg.properties.efect = efectv;	*/
			/* Works correctly now.. :)			*/
			/* - MiKiL					*/

				cfg.properties.shade = efectv;
		}
	
		else if (!strncasecmp(lns , "MaxGrow:" , 8))
		{
			lns += 8;
			for( ; *lns && isspace(*lns) ; lns++);
			max_growv = _atof(lns);
			if (errno == ERANGE || (max_growv <= (gfloat)0.0))
			{
				printf(gettext("bad grow value: %s , (positive float number required)\n") , lns);
				max_growv = default_max_grow;
			}
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));

				pe->prop->max_grow = max_growv;
			}
			else
				cfg.properties.max_grow = max_growv;
		}
		else if (!strncasecmp(lns , "BackgroundColor:" , 16))
		{
			GdkColor *clr;

			lns += 16;
			for( ; *lns && isspace(*lns) ; lns++);

			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));
				clr = &pe->prop->background;
			}
			else
				clr = &cfg.properties.background;

			if (!gdk_color_parse(lns , clr))
			{
				printf(gettext("unknown color: %s\n") , lns);
				gdk_color_parse("#000000" , clr);
			}
		}

		/* Next step : changed lns parameter here to 17 because */
		/* of one more charater longer parameter name.. 	*/
		/* If not corrected says "unknown color: : #??????"	*/
		/* Reason : started reading color from wrong place.. 	*/

		else if (!strncasecmp(lns , "BackgroundColor2:" , 17))
		{
			GdkColor *clr;

			lns += 17;
			for( ; *lns && isspace(*lns) ; lns++);

			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));
				clr = &pe->prop->background2;
			}
			else
				clr = &cfg.properties.background2;

			if (!gdk_color_parse(lns , clr))
			{
				printf(gettext("unknown color: %s\n") , lns);
				gdk_color_parse("#000000" , clr);
			}
		}
		else if (!strncasecmp(lns , "RandomizeColors:" , 16))
		{
			lns += 16;
			for( ; *lns && isspace(*lns) ; lns++);
			if (pe)
			{
				if (!pe->prop) 
					pe->prop = g_memdup(&cfg.properties , sizeof(propt));
				if (!strcasecmp(lns , "true"))
					pe->prop->rand_colors = TRUE;
				else
					pe->prop->rand_colors = FALSE;
			}
			else
			{
				if (!strcasecmp(lns , "true"))
					cfg.properties.rand_colors = TRUE;
				else
					cfg.properties.rand_colors = FALSE;
			}
		}
		else if (!strncasecmp(lns , "Randomize:" , 10))
		{
			lns += 10;
			for( ; *lns && isspace(*lns) ; lns++);
			if (!strcasecmp(lns , "true"))
				cfg.randomize = TRUE;
			else
				cfg.randomize = FALSE;
		}
		else if (!strncasecmp(lns , "Recurse:" , 8))
		{
			lns += 8;
			for( ; *lns && isspace(*lns) ; lns++);
			if (!strcasecmp(lns , "true"))
				cfg.recurse = TRUE;
			else
				cfg.recurse = FALSE;
		}
		else if (!strncasecmp(lns , "Blank:" , 6))
		{
			lns += 6;
			for( ; *lns && isspace(*lns) ; lns++);
			if (!strcasecmp(lns , "true"))
				cfg.blank = TRUE;
			else
				cfg.blank = FALSE;
		}
		else if (!strncasecmp(lns , "InWindow:" , 6))
		{
			lns += 6;
			for( ; *lns && isspace(*lns) ; lns++);
			if (!strcasecmp(lns , "true"))
				cfg.inwindow = TRUE;
			else
				cfg.inwindow = FALSE;
		}
		else if (!strncasecmp(lns , "CycleBlank:" , 11))
		{
			lns += 11;
			for( ; *lns && isspace(*lns) ; lns++);
			if (!strcasecmp(lns , "true"))
				cfg.cycle_blank = TRUE;
			else
				cfg.cycle_blank = FALSE;
		}
		else if (!strncasecmp(lns , "Picture:" , 8))
		{
			lns += 8;
			for( ; *lns && isspace(*lns) ; lns++);

			pe = g_malloc(sizeof(picentry));
			pe->prop = NULL;
			pe->name = g_strdup(lns);

			cfg.pics = g_slist_append(cfg.pics , (gpointer)pe);
			cfg.num_pics ++;
		}
		else if (!strncasecmp(lns , "Pattern:" , 8))
		{
			lns += 8;
			for( ; *lns && isspace(*lns) ; lns++);

			cfg.pattern = g_slist_append(cfg.pattern , g_strdup(lns));
		}
		else
		{
			printf(gettext("Unable to parse line:\n%s\n") , line);
		}
	}
	fclose(f);

	return 0;
}

#define HEX(x) (((x) > 9) ? 'a' + (x) - 10 : '0' + (x))

guchar *cfg_get_color_str(color)
GdkColor *color;
{
	guchar r,g,b;
	static guchar str[8];

	r = color->red / 256;
	g = color->green / 256;
	b = color->blue / 256;

	str[0]= '#';
	str[1]= HEX(r >> 4);
	str[2]= HEX(r & 0x0f);
	str[3]= HEX(g >> 4);
	str[4]= HEX(g & 0x0f);
	str[5]= HEX(b >> 4);
	str[6]= HEX(b & 0x0f);
	str[7]= '\0';

	return str;
}

int cfg_save_scenario(scenario)
gchar *scenario;
{
	FILE *f;
	GSList *ptr;
	picentry *pe;

	if (!(f = fopen(scenario , "w")))
	{
		perror(scenario);
		return -1;
	}

	fprintf(f , gettext("# this is automaticaly generated chbg scenario file\n\n"));
	fprintf(f , "Blank: %s\n" , cfg.blank ? "true" : "false");
	fprintf(f , "Speed: %d\n" , cfg.speed);
	fprintf(f , "Recurse: %s\n" , cfg.recurse ? "true" : "false");
	fprintf(f , "InWindow: %s\n" , cfg.inwindow ? "true" : "false");
	fprintf(f , "Randomize: %s\n\n" , cfg.randomize ? "true" : "false");
	fprintf(f , "CycleBlank: %s\n\n" , cfg.cycle_blank ? "true" : "false");

	ptr = cfg.pattern;
	while(ptr)
	{
		fprintf(f , "Pattern: %s\n" , (char *)ptr->data);
		ptr = ptr->next;
	}

	fprintf(f , "BackgroundColor: %s\n" , cfg_get_color_str(&cfg.properties.background));
	fprintf(f , "BackgroundColor2: %s\n" , cfg_get_color_str(&cfg.properties.background2));

	fprintf(f , "RandomizeColors: %s\n" , cfg.properties.rand_colors ? "true" : "false");
	fprintf(f , "RenderingMode: %s\n" , cfg_get_mode_str(cfg.properties.type));
	fprintf(f , "MaxGrow: %.1f\n" , cfg.properties.max_grow);
	fprintf(f , "MaxSize: %d\n" , cfg.properties.max_size);
	fprintf(f , "Interval: %.2f\n" , cfg.properties.interval);

/* Next line : One "\n" in Efect-line too much. Didnt load efect & shader */
/* parameters correctly...						  */

	fprintf(f , "Efect: %d\n" , cfg.properties.efect);
	fprintf(f , "Shader: %d\n\n" , cfg.properties.shade);

	ptr = cfg.pics;
	while(ptr)
	{
		pe = (picentry *) ptr->data;

		fprintf(f , "Picture: %s\n" , pe->name);
		if (pe->prop)
		{
			fprintf(f , "RenderingMode: %s\n" , cfg_get_mode_str(pe->prop->type));
			fprintf(f , "MaxGrow: %.1f\n" , pe->prop->max_grow);
			fprintf(f , "MaxSize: %d\n" , pe->prop->max_size);
			fprintf(f , "BackgroundColor: %s\n" , cfg_get_color_str(&pe->prop->background));
			fprintf(f , "BackgroundColor2: %s\n" , cfg_get_color_str(&pe->prop->background2));
			fprintf(f , "RandomizeColors: %s\n" , pe->prop->rand_colors ? "true" : "false");
			fprintf(f , "Interval: %.2f\n" , pe->prop->interval);
			fprintf(f , "Efect: %d\n" , pe->prop->efect);
			fprintf(f , "Shader: %d\n\n" , pe->prop->shade);
		}
		ptr = ptr->next;
	}
	
	fclose(f);

	return 0;
}


