/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 Ondrejicka Stefan			   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include <gdk_imlib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <math.h>

#ifdef HAVE_FNMATCH
#include <fnmatch.h>
#else
#include "fnmatch.h"
#endif

#include "config.h"

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif

#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

#define ServeEvents if (stop_changing) return; else while(gtk_events_pending()) gtk_main_iteration();

GdkWindow *screensaver_window = NULL;
guint tid = 0;

extern GdkWindow *xss_get_window();
extern guint restart_loop;

gboolean stop_changing = FALSE;
gboolean have_setup = FALSE;

#ifdef NO_USLEEP
void usleep(usec)
unsigned long usec;
{
	struct timeval tout;

	tout.tv_sec = 0;
	tout.tv_usec = usec;
	select(0 , NULL , NULL , NULL , &tout);
}
#endif

#ifdef NO_SETENV
int setenv(var , val , ovr)
char *var;
char *val;
int ovr;
{
	char *pom=g_malloc(strlen(var) + strlen(val) + 2);

	sprintf(pom , "%s=%s" , var , val);
	return putenv(pom);
}

#define unsetenv(var) setenv(var , "" , 1)

#endif

static void Switch(data)
gpointer data;
{
	if (tid)
	{
		gtk_timeout_remove(tid);
		tid = 0;
		gtk_main_quit();
	}
}

void event_func(event)
GdkEvent *event;
{
	if (event->any.window == screensaver_window)
	{
		switch(event->any.type)
		{
			case GDK_BUTTON_RELEASE:
			case GDK_KEY_RELEASE:
				gdk_pointer_ungrab(gdk_time_get());
				gdk_keyboard_ungrab(gdk_time_get());
				gdk_window_destroy(screensaver_window);
				if (have_setup)
				{
					if (gtk_main_level() > 1)
						gtk_main_quit();
				}
				else
					gtk_exit(0);
				stop_changing = TRUE;
				break;
			case GDK_VISIBILITY_NOTIFY:
			case GDK_CONFIGURE:
				gdk_window_raise(screensaver_window);
				break;
			default: break;
		}
	}
	else
		gtk_main_do_event(event);
}

void win_event_func(event)
GdkEvent *event;
{
	if (event->any.window == screensaver_window)
	{
		switch(event->any.type)
		{
			case GDK_KEY_RELEASE:
			{
				GdkEventKey *kevent = (GdkEventKey *)event;
				switch(kevent->keyval)
				{
					case GDK_Q:
					case GDK_q:
					case GDK_Escape:
						stop_changing = TRUE;
						if (have_setup)
						{
							if (gtk_main_level() > 1)
								gtk_main_quit();
						}
						else
							gtk_exit(0);
					break;
					case GDK_n:
					case GDK_N:
					case GDK_space:
						Switch(NULL);
					break;
					default:
					break;
				}
			}
			break;
			default: 
			break;
		}
	}
	else
		gtk_main_do_event(event);
}

void init_window()
{
	GdkWindow	*root_window;
	GdkWindowAttr	wattr;

	root_window = GDK_ROOT_PARENT();
	
	wattr.title = "ChBg window";
	wattr.event_mask = GDK_KEY_RELEASE_MASK |
			GDK_KEY_PRESS_MASK;
	wattr.x = 0 ;
	wattr.y = 0;
	wattr.width = 100;
	wattr.height = 100;
	wattr.wclass = GDK_INPUT_OUTPUT;
	wattr.visual = gdk_window_get_visual(root_window);
	wattr.window_type = GDK_WINDOW_TOPLEVEL;
	wattr.override_redirect = FALSE;
	screensaver_window = gdk_window_new(root_window , &wattr ,
		GDK_WA_TITLE | GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_NOREDIR);

	gdk_event_handler_set((GdkEventFunc) win_event_func , NULL , NULL);
	gdk_window_show(screensaver_window);
	gdk_window_raise(screensaver_window);
}

void init_screensaver()
{
	GdkWindow	*root_window;
	GdkWindowAttr	wattr;
	guint		rw,rh;

	root_window = GDK_ROOT_PARENT();
	gdk_window_get_size(root_window , &rw, &rh);
	
	wattr.title = "ChBg window";
	wattr.event_mask = GDK_BUTTON_RELEASE_MASK |
			GDK_KEY_RELEASE_MASK |
			GDK_BUTTON_PRESS_MASK | 
			GDK_KEY_PRESS_MASK |
			GDK_VISIBILITY_NOTIFY_MASK |
			GDK_SUBSTRUCTURE_MASK;

	wattr.x = 0 ;
	wattr.y = 0;
	wattr.width = rw;
	wattr.height = rh;
	wattr.wclass = GDK_INPUT_OUTPUT;
	wattr.visual = gdk_window_get_visual(root_window);
	wattr.window_type = GDK_WINDOW_TOPLEVEL;
	wattr.override_redirect = TRUE;
	screensaver_window = gdk_window_new(root_window , &wattr ,
		GDK_WA_TITLE | GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_NOREDIR);

	gdk_event_handler_set((GdkEventFunc) event_func , NULL , NULL);
	gdk_window_show(screensaver_window);
	gdk_window_raise(screensaver_window);
	gdk_keyboard_grab(screensaver_window , TRUE , gdk_time_get());
	gdk_pointer_grab(screensaver_window, TRUE,
		GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK ,
		NULL, gdk_cursor_new (GDK_ARROW), gdk_time_get());
	
}

void chbg_clear_window(window , type)
GdkWindow *window;
int type;
{
	gint i,j,k,l;
	gint w,h;

	gdk_window_get_size(window , &w, &h);

	if (!type) type = (int)((float)NUM_EFECTS*(float)rand()/(RAND_MAX +1.0));

	switch (type)
	{
		case 1:
			gdk_window_clear(window);
		break;
		case 2:
			for (i = w/2 ; i ; i--)
			{
				gdk_window_clear_area(window , i , 0 , 1 , h);
				gdk_window_clear_area(window , w - i , 0 , 1 , h);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 3:
			for (i = h/2 ; i ; i--)
			{
				gdk_window_clear_area(window , 0 , i , w , 1);
				gdk_window_clear_area(window , 0 , h - i , w , 1);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 4:
			for (i = 0 ; i <= w/2 ; i++)
			{
				gdk_window_clear_area(window , i , 0 , 1 , h);
				gdk_window_clear_area(window , w - i , 0 , 1 , h);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 5:
			for (i = 0 ; i <= h/2 ; i++)
			{
				gdk_window_clear_area(window , 0 , i , w , 1);
				gdk_window_clear_area(window , 0 , h - i , w , 1);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 6:
			for (i = 0 ; i < h ; i++)
			{
				gdk_window_clear_area(window , 0 , i , w , 1);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 7:
			for (i = 0 ; i < w ; i++)
			{
				gdk_window_clear_area(window , i , 0 , 1 , h);
				gdk_flush();
				usleep(cfg.speed/3);
				ServeEvents
			}
		break;
		case 8:
			for (i = 0 ; i <= MAX(w/2,h/2) ; i++)
			{
				gdk_window_clear_area(window , w/2 - i , h/2 - i , 2*i + 1 , 1);
				gdk_window_clear_area(window , w/2 - i , h/2 - i , 1 , 2*i + 1);
				gdk_window_clear_area(window , w/2 - i , h/2 + i , 2*i + 1 , 1);
				gdk_window_clear_area(window , w/2 + i , h/2 - i , 1 , 2*i + 1);
				gdk_flush();
				usleep(cfg.speed/2);
				ServeEvents
			}
		break;
		case 9:
			for (i = 0 ; i <= MIN(w/2,h/2) ; i++)
			{
				gdk_window_clear_area(window , i ,  i , w - 2*i , 1);
				gdk_window_clear_area(window , i , i , 1 , h - 2*i);
				gdk_window_clear_area(window , i , h - i , w - 2*i + 1 , 1);
				gdk_window_clear_area(window , w - i , i , 1 , h - 2*i + 1);
				gdk_flush();
				usleep(cfg.speed/2);
				ServeEvents
			}
		break;
		case 10:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j < w ; j += i)
				{
					gdk_window_clear_area(window , j , 0 , 1 , h);
				}
				usleep(3*cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 11:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j < h ; j += i)
				{
					gdk_window_clear_area(window , 0 , j , w , 1);
					usleep(cfg.speed/20);
				}
				usleep(cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 12:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j < MAX(w , h) ; j += i)
				{
					gdk_window_clear_area(window , 0 , j , w , 1);
					gdk_window_clear_area(window , j , 0 , 1 , h);
					usleep(cfg.speed/20);
				}
				usleep((i/2)*cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 13:
			for (i = 0 ; i < MAX(w,h) ; i++)
			{
				gdk_window_clear_area(window , i , 0 , 1 , i+1);
				gdk_window_clear_area(window , 0 , i , i+1 , 1);
				usleep(cfg.speed/3);
				gdk_flush();
				ServeEvents
			}
		break;
		case 14:
			for (i = 0 ; i <= MAX(w/2,h/2) ; i++)
			{
				gdk_window_clear_area(window , i , 0 , 1 , i+1);
				gdk_window_clear_area(window , 0 , i , i+1 , 1);
				gdk_window_clear_area(window , w - i , 0 , 1 , i+1);
				gdk_window_clear_area(window , w - i , i , i+1 , 1); 
				gdk_window_clear_area(window , 0 , h-i , i+1 , 1);
				gdk_window_clear_area(window , i , h-i , 1 , i+1);
				gdk_window_clear_area(window , w - i , h - i , 1 , i + 1);
				gdk_window_clear_area(window , w - i , h - i , i + 1 ,1);


				usleep(cfg.speed/3);
				gdk_flush();
				ServeEvents
			}
		break;
		case 15:
#define BOX_SIZE 16 
			for(i = 0 ; i <= MAX(w,h) ; i += BOX_SIZE)
			{
				k = i;
				for (j = 0 ; j <= i ; j += BOX_SIZE, k -= BOX_SIZE)
				{
					if (k > (h/2 + BOX_SIZE) || j > (w/2 + BOX_SIZE)) continue;

					gdk_window_clear_area(window , j , k , BOX_SIZE , BOX_SIZE);
					gdk_window_clear_area(window , j , h-k , BOX_SIZE , BOX_SIZE);
					gdk_window_clear_area(window , w-j , k , BOX_SIZE , BOX_SIZE);
					gdk_window_clear_area(window , w-j , h-k , BOX_SIZE , BOX_SIZE);

					gdk_flush();
					usleep(cfg.speed/3);
				}
				ServeEvents
			}
		break;
		case 16:
			for(k = 0 ; k <= MIN(h/2,w/2) ; k += BOX_SIZE)
			{
				for(i = k ; i <= (w - k) ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , i , k , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k)  ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , w - k - BOX_SIZE , i , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (w - k) ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , w - i , h - k - BOX_SIZE , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k) ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , k , h - i , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				ServeEvents
			}
		break;
		case 17:
			for(k = MIN(h/2,w/2) ; k > -BOX_SIZE ; k -= BOX_SIZE)
			{
				for(i = k + BOX_SIZE ; i <= (w - k) ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , i , k , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k)  ; i += BOX_SIZE)
				{
					/*gdk_window_clear_area(window , w - k , h - i , BOX_SIZE , BOX_SIZE);*/
					gdk_window_clear_area(window , w - k , i , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (w - k) ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , w - i , h - k , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				for(i = k ; i <= (h - k + BOX_SIZE) ; i += BOX_SIZE)
				{
					gdk_window_clear_area(window , k , h - i , BOX_SIZE , BOX_SIZE);
					gdk_flush();
					usleep(cfg.speed/100);
				}
				ServeEvents
			}
		break;
		case 18:
			for (i = 256 ; i ; i /= 2)
			{
				for(j = 0 ; j <= MAX(w/2 , h/2) ; j += i)
				{
					gdk_window_clear_area(window , 0 , h/2 + j , w , 1);
					gdk_window_clear_area(window , 0 , h/2 - j , w , 1);
					gdk_window_clear_area(window , w/2 - j , 0 , 1 , h);
					gdk_window_clear_area(window , w/2 + j , 0 , 1 , h);
					usleep(cfg.speed/20);
				}
				usleep((i/2)*cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 19:
			for (k = 8 ; k ; k--)
			{
				for (j = 0 ; j <= h/BOX_SIZE ; j++)
				{
					for(i = ((k + j) % 8) * BOX_SIZE  ; i < w ; i+= 8 * BOX_SIZE)
					{
						gdk_window_clear_area(window , i  ,  j * BOX_SIZE , BOX_SIZE , BOX_SIZE);
					}
					usleep(cfg.speed/2);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 20:
			for (k = 8 ; k ; k--)
			{
				l = 8;
				for (j = 0 ; j <= h/BOX_SIZE ; j++)
				{
					l += ((j/8)%2 ? 1 : -1);
					for(i = ((k - l) % 8) * BOX_SIZE  ; i < w ; i+= 8 * BOX_SIZE)
					{
						gdk_window_clear_area(window , i  ,  j * BOX_SIZE , BOX_SIZE , BOX_SIZE);
					}
					usleep(cfg.speed);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 21:
			for (i = 0 ; i <= w ; i += BOX_SIZE)
			{
				for (j = 0 ; j <= h ; j += BOX_SIZE)
				{
					if ((j/BOX_SIZE) % 2)
						gdk_window_clear_area(window , w - i - BOX_SIZE , j , BOX_SIZE, BOX_SIZE);
					else
						gdk_window_clear_area(window , i , j , BOX_SIZE, BOX_SIZE);
				}
				usleep(cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		case 22:
			for (i = 0 ; i <= h ; i += BOX_SIZE)
			{
				for (j = 0 ; j <= w ; j += BOX_SIZE)
				{
					if ((j/BOX_SIZE) % 2)
						gdk_window_clear_area(window , j , h - i - BOX_SIZE , BOX_SIZE, BOX_SIZE);
					else
						gdk_window_clear_area(window , j , i , BOX_SIZE, BOX_SIZE);
				}
				usleep(cfg.speed/2);
				gdk_flush();
				ServeEvents
			}
		break;
		case 23:
			for (i = 0 ; i < w * h * 2 ; i += BOX_SIZE*BOX_SIZE)
			{
				j = (int) ((float)rand() * (((float)(w * h)/(float) (BOX_SIZE*BOX_SIZE)) / (float)RAND_MAX));

				k = (j / (w/BOX_SIZE)) * BOX_SIZE;
				l = (j % (w/BOX_SIZE)) * BOX_SIZE;

				gdk_window_clear_area(window , l , k , BOX_SIZE , BOX_SIZE);

				usleep(cfg.speed/50);
				gdk_flush();
				ServeEvents
			}
			for (i = 0 ; i <= h ; i += BOX_SIZE)
			{
				gdk_window_clear_area(window , 0 , i , w , BOX_SIZE);
				usleep(cfg.speed/10);
				gdk_flush();
				ServeEvents
			}
		break;
		case 24:
			for (i = 0 ; i <= h ; i += BOX_SIZE)
			{
				for(j = 0 ; j <= w ; j += BOX_SIZE)
				{
					if ((i/BOX_SIZE)%2)
						gdk_window_clear_area(window , w - j , i , BOX_SIZE , BOX_SIZE);
					else
						gdk_window_clear_area(window , j , i , BOX_SIZE , BOX_SIZE);

					usleep(cfg.speed/50);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 25:
			for (i = 0 ; i <= w ; i += BOX_SIZE)
			{
				for(j = 0 ; j <= h ; j += BOX_SIZE)
				{
					if ((i/BOX_SIZE)%2)
						gdk_window_clear_area(window , i , h - j , BOX_SIZE , BOX_SIZE);
					else
						gdk_window_clear_area(window , i , j , BOX_SIZE , BOX_SIZE);

					usleep(cfg.speed/50);
					gdk_flush();
				}
				ServeEvents
			}
		break;
		case 26:
			for (i = 0 ; i <= w ; i += 2)
			{
				gdk_window_clear_area(window , i , 0 , 1 , h);
				gdk_window_clear_area(window , w - i + (w%2 ? 0 : 1) , 0 , 1 , h);
				usleep(cfg.speed/50);
				gdk_flush();
				ServeEvents
			}
		break;
		case 27:
			for (i = 0 ; i <= h ; i += 2)
			{
				gdk_window_clear_area(window , 0 , i , w , 1);
				gdk_window_clear_area(window , 0 , h - i + (h%2 ? 0 : 1), w , 1);
				usleep(cfg.speed/50);
				gdk_flush();
				ServeEvents
			}
		break;
		case 28:
			for (i = 0 ; i <= w ; i += BOX_SIZE)
			{
				for (j = 0 ; j <= h ; j += BOX_SIZE)
				{
					k = (int)((float)3*(float)rand()/(RAND_MAX+1.0));
					gdk_window_clear_area(window , i + (k*BOX_SIZE) , j , BOX_SIZE , BOX_SIZE);
				}
				gdk_window_clear_area(window , i , 0 , BOX_SIZE , h);
				usleep(cfg.speed/2);
				gdk_flush();
				ServeEvents
			}
			gdk_window_clear(window);
		break;
		case 29:
			k = (1+w/BOX_SIZE);
			k = (k + (1-k%2))*BOX_SIZE;
			l = (1+h/BOX_SIZE);
			l = (l + (1-l%2))*BOX_SIZE;

			for (i = 0 ; i <= MAX(w,h) ; i += 2 * BOX_SIZE)
			{
				gdk_window_clear_area(window , i , 0 , BOX_SIZE , h);
				gdk_window_clear_area(window , k - i , 0 , BOX_SIZE , h);
				gdk_window_clear_area(window , 0 , i , w , BOX_SIZE);
				gdk_window_clear_area(window , 0 , l - i , w , BOX_SIZE);
				
				usleep(20*cfg.speed);
				gdk_flush();
				ServeEvents
			}
		break;
		default:
			gdk_window_clear(window);
	}

}
#ifdef HAVE_ESETROOT_SUPPORT
void set_pixmap_property(root_window , p, w, h , prop)
GdkWindow *root_window;
GdkPixmap *p;
guint w,h;
propt *prop;
{
  GdkAtom prop_root;
  static GdkPixmap *esetroot_pixmap = NULL;
  GdkGC *gc;

  if ( p == NULL ) return;
  if ( esetroot_pixmap != NULL )
    gdk_imlib_free_pixmap(esetroot_pixmap);
  
  gc = gdk_gc_new( root_window );
  gdk_gc_set_foreground( gc, &prop->background );
  esetroot_pixmap = gdk_pixmap_new( root_window, w, h,
                                    gdk_visual_get_best_depth() );
  gdk_draw_rectangle( esetroot_pixmap, gc, TRUE, 0, 0, w, h );
  gdk_draw_pixmap( esetroot_pixmap, gc, p, 0, 0, 0, 0, w, h );
  gdk_gc_unref(gc);

  /* This will locate the property, creating it if it doesn't exist */
  prop_root = gdk_atom_intern("_XROOTPMAP_ID", FALSE);

  /* The call above should have created it.  If that failed, we can't continue. 
*/
  if (prop_root == GDK_NONE) return;
  gdk_property_change( root_window, prop_root, GDK_TARGET_PIXMAP, 32,
                       PropModeReplace,
                       (unsigned char *) &((GdkPixmapPrivate *)esetroot_pixmap)->xwindow, 1 );

  return;
}
#endif /* HAVE_ESETROOT_SUPPORT */

void shade_pixmap(prop, pixmap, gc , w ,h)
propt *prop;
GdkPixmap *pixmap;
GdkGC *gc;
guint w;
guint h;
{
	int x,y;
	guchar *lnbuf;
	guchar *p;
	guchar r0,r1,g0,g1,b0,b1;
	guchar r,g,b;
	int type;

	if (!prop->shade) return;

	if (prop->rand_colors)
	{
		r0 = (int)(255.0*(float)rand()/(RAND_MAX +1.0));
		g0 = (int)(255.0*(float)rand()/(RAND_MAX +1.0));
		b0 = (int)(255.0*(float)rand()/(RAND_MAX +1.0));

		r1 = (int)(255.0*(float)rand()/(RAND_MAX +1.0));
		g1 = (int)(255.0*(float)rand()/(RAND_MAX +1.0));
		b1 = (int)(255.0*(float)rand()/(RAND_MAX +1.0));
	}
	else
	{
		r0 = prop->background.red/256 ;
		g0 = prop->background.green/256;
		b0 = prop->background.blue/256;

		r1 = prop->background2.red/256 ;
		g1 = prop->background2.green/256;
		b1 = prop->background2.blue/256;
	}

	lnbuf = g_malloc(3 * w);

	if (prop->shade == 1)
		type = 2 + (int)((float)(NUM_SHADERS-2)*(float)rand()/(RAND_MAX + 1.0));
	else
		type = prop->shade;

	for (y = 0 ; y < h ; y++)
	{
		p = lnbuf;
		ServeEvents
		for (x = 0 ; x < w ; x++)
		{
			double factor,factor2;

			switch(type)
			{
				case 2:
					factor = (double)x/(double)w;
				break;
				case 3:
					factor = (double)x/(double)w - 1.0;
					factor = sqrt(1.0 - factor * factor);
				break;
				case 4:
					factor = (double)x/(double)w;
					factor = 1.0 - sqrt(1.0 - factor * factor);
				break;
				case 5:
					factor = (double)x/(double)w;
					factor = (sin((-M_PI / 2.0) + M_PI * factor) + 1.0)/2.0;
				break;
				case 6:
					factor = (double)x/(double)w;
					factor = sin(M_PI * factor);
				break;
				case 7:
					factor = (double)y/(double)h;
				break;
				case 8:
					factor = (double)y/(double)h - 1.0;
					factor = sqrt(1.0 - factor * factor);
				break;
				case 9:
					factor = (double)y/(double)h;
					factor = 1.0 - sqrt(1.0 - factor * factor);
				break;
				case 10:
					factor = (double)y/(double)h;
					factor = (sin((-M_PI / 2.0) + M_PI * factor) + 1.0)/2.0;
				break;
				case 11:
					factor = (double)y/(double)h;
					factor = sin(M_PI * factor);
				break;
				case 12:
					factor = sqrt((double)(x*y))/sqrt((double)(w*h));
				break;
				case 13:
					factor = sqrt((double)((w-x)*(h-y)))/sqrt((double)(w*h));
				break;
				case 14:
					factor = sqrt((double)((w-x)*(y)))/sqrt((double)(w*h));
				break;
				case 15:
					factor = sqrt((double)((x)*(h-y)))/sqrt((double)(w*h));
				break;
				case 16:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
				break;
				case 17:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*h));
				break;
				case 18:
					factor = 2.0 * sqrt((double)(abs(h/2-y)*abs(w/2-x)))/sqrt((double)(w*h));
				break;
				case 19:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2+1-y)*(h/2+1-y)-(w/2+1-x)*(w/2+1-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(4 * M_PI * factor))/2.0;
				break;
				case 20:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4+h*h/4));
					factor = (factor - factor * sin(4 * M_PI * factor))/2.0;
				break;
				case 21:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 22:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = 1.0 - factor;
					factor = (factor - factor * sin(16 * M_PI * (1.0 - factor)))/2.0;
				break;
				case 23:
					factor = sqrt((double)(h*h/4+w*w/4 - x*x/4 - y*y/4))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 24:
					factor = sqrt((double)(h*h/4+w*w/4 - (w-x)*(w-x)/4 - (h-y)*(h-y)/4))/sqrt((double)(w*w/4+h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 25:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 26:
					factor = (double)x/(double)w;
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 27:
					factor = (double)y/(double)h;
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 28:
					factor = (double)(y+x)/(double)(h+w);
				break;
				case 29:
					factor = (double)((w-x)+y)/(double)(h+w);
				break;
				case 30:
					factor = (double)(y+x)/(double)(h+w);
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 31:
					factor = (double)((w-x)+y)/(double)(h+w);
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
				break;
				case 32:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * (double)x/(double)w))/2.0;
				break;
				case 33:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * (double)x/(double)w))/2.0;
				break;
				case 34:
					factor = (double)(y+x)/(double)(h+w);
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor *= (double)((w-x)+y)/(double)(h+w);
				break;
				case 35:
					factor = (double)(y+x)/(double)(h+w);
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (double)((w-x)+y)/(double)(h+w);
					factor2 = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 36:
					factor = (double)(y+x)/(double)(h+w);
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (double)((w-x)+y)/(double)(h+w);
					factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 37:
					factor = (double)x/(double)w;
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (double)y/(double)h;
					factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 38:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (double)y/(double)h;
					factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 39:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (double)x/(double)w;
					factor2 = (factor2 - factor2 * sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 40:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor2 = (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 41:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor2 = (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 42:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor2 = (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 43:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 44:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 45:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor2 = (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 46:
					factor = (double)x/(double)w;
					factor = (1.0 + sin(16 * M_PI * factor))/2.0;
					factor2 = (double)y/(double)h;
					factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 47:
					factor = (double)(y+x)/(double)(h+w);
					factor = (1.0 + sin(16 * M_PI * factor))/2.0;
					factor2 = (double)((w-x)+y)/(double)(h+w);
					factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
				break;
				case 48:
					factor = (double)(y+x)/(double)(h+w);
					factor = (1.0 + sin(16 * M_PI * factor))/2.0;
					factor2 = (double)((w-x)+y)/(double)(h+w);
					factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
					factor2 = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor + factor2)/2.0;
				break;
				case 49:
					factor = (double)(y+x)/(double)(h+w);
					factor = (1.0 + sin(16 * M_PI * factor))/2.0;
					factor2 = (double)((w-x)+y)/(double)(h+w);
					factor2 = (1.0 + sin(16 * M_PI * factor2))/2.0;
					factor = (factor + factor2)/2.0;
					factor2 = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*h));
					factor = (factor + factor2)/2.0;
				break;
				case 50:
					factor = (double)(y+x)/(double)(h+w);
					factor = (1.0 + sin(16 * M_PI * factor))/2.0;
					factor2 = (double)((w-x)+y)/(double)(h+w);
					factor *= (1.0 + sin(16 * M_PI * factor2))/2.0;
				break;
				case 51:
					factor = (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0;
					factor *= (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0;
				break;
				case 52:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(16 * M_PI * (double)y/(double)h))/2.0;
				break;
				case 53:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(16 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(16 * M_PI * (double)x/(double)w))/2.0;
				break;
				case 54:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
				break;
				case 55:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
				break;
				case 56:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
				break;
				case 57:
					factor = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)(y+x)/(double)(h+w)))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
				break;
				case 58:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
				break;
				case 59:
					factor = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor = (factor - factor * sin(32 * M_PI * factor))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)(y+x)/(double)(h+w)))/2.0;
					factor *= (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
				break;
				case 60:
					factor = (1.0 + sin(32 * M_PI * (double)(x+y)/(double)(w+h)))/2.0;
					factor += (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
					factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
					factor2 += (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
					factor = (factor * factor2)/4.0;
				break;
				case 61:
					factor = (1.0 + sin(32 * M_PI * (double)(x+y)/(double)(w+h)))/2.0;
					factor += (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
					factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
					factor2 += (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
					factor = (factor * factor2)/4.0;
					factor2 = sqrt((double)((h/2-y)*(h/2-y)+(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor *= (factor2 - factor2 * sin(32 * M_PI * factor2))/2.0;
				break;
				case 62:
					factor = (1.0 + sin(32 * M_PI * (double)(x+y)/(double)(w+h)))/2.0;
					factor += (1.0 + sin(32 * M_PI * (double)((w-x)+y)/(double)(w+h)))/2.0;
					factor2 = (1.0 + sin(32 * M_PI * (double)y/(double)h))/2.0;
					factor2 += (1.0 + sin(32 * M_PI * (double)x/(double)w))/2.0;
					factor = (factor * factor2)/4.0;
					factor2 = sqrt((double)(h*h/4+w*w/4-(h/2-y)*(h/2-y)-(w/2-x)*(w/2-x)))/sqrt((double)(w*w/4 + h*h/4));
					factor *= (factor2 - factor2 * sin(32 * M_PI * factor2))/2.0;
				break;
				default:
					factor = (double)x/(double)w;
			}

#if 1
			if (factor > 1.0)
				printf("overflow at %dx%d\n" , x ,y);
			if (factor < 0.0)
				printf("underflow at %dx%d\n", x, y);
#endif

			r = r0 + (guchar)((double)(r1 - r0) * factor);
			g = g0 + (guchar)((double)(g1 - g0) * factor);
			b = b0 + (guchar)((double)(b1 - b0) * factor);
			p[0] = r;
			p[1] = g;
			p[2] = b;
			p += 3;
		}
		gdk_draw_rgb_image(pixmap , gc , 0 , y , w , 1 , 
			GDK_RGB_DITHER_NORMAL, lnbuf, 0);
	}

	g_free(lnbuf);
}

static void set_blank_screen(prop)
propt *prop;
{
	GdkPixmap *pixmap;
	GdkWindow *root_window;
	GdkGC *gc;
	guint rw = 1,rh = 1;

	root_window = (cfg.screensaver || cfg.xscreensaver || cfg.inwindow) ?
			screensaver_window : GDK_ROOT_PARENT();

	gdk_window_get_size(root_window , &rw, &rh);

	gc = gdk_gc_new(root_window);
	gdk_gc_set_foreground(gc , &prop->background);

	if (prop->shade)
	{
		pixmap = gdk_pixmap_new(root_window, rw , rh , 
				gdk_visual_get_best_depth());
		gdk_draw_rectangle(pixmap , gc , TRUE , 0 , 0 , rw , rh);
		shade_pixmap(prop, pixmap , gc , rw , rh);
	}
	else
	{
		pixmap = gdk_pixmap_new(root_window , 1 , 1 , 
				gdk_visual_get_best_depth());
		gdk_draw_point(pixmap , gc , 0 , 0);
	}

	gdk_window_set_back_pixmap(root_window, pixmap, FALSE);
	chbg_clear_window(root_window , prop->efect);

#ifdef HAVE_ESETROOT_SUPPORT
	if (!cfg.inwindow && !cfg.screensaver && 
		!cfg.xscreensaver && !stop_changing)
			set_pixmap_property(root_window,pixmap,rw,rh,prop);
#endif /* HAVE_ESETROOT_SUPPORT */

	gdk_gc_unref(gc);
	gdk_pixmap_unref(pixmap);

	gdk_flush();
}


int set_root_bg(imgname , prop)
gchar *imgname;
propt *prop;
{
	GdkImlibImage 	*image;
	GdkWindow	*root_window;
	GdkPixmap	*pixmap = NULL;
	GdkVisual	*visual;
	guint		rw,rh;
	shtype		type;

	root_window = (cfg.screensaver || cfg.xscreensaver || cfg.inwindow) ?
			screensaver_window : GDK_ROOT_PARENT();

	gdk_window_get_size(root_window , &rw, &rh);

	visual = gdk_window_get_visual(root_window);
	if (visual != gdk_imlib_get_visual())
		return -1;    

	image = gdk_imlib_load_image(imgname);

	if (!image)
		return -1;

	type = prop->type;

	if (cfg.inwindow && !cfg.windowid)
	{
		rw = image->rgb_width;
		rh = image->rgb_height;
		gdk_window_resize(screensaver_window , rw, rh);
		while(gtk_events_pending())gtk_main_iteration();
		type = CENTER;
	}


	if ((prop->type == TILE || prop->type == MIRROR) && 
		(((image->rgb_width * 3/2) > rw && (image->rgb_height * 3) > rh) ||
		 ((image->rgb_height * 3/2) > rh && (image->rgb_width * 3 ) > rw)))
		type = MAX_ASP_RATIO_CENTER; 

	switch (type)
	{
		case TILE:
			rw = image->rgb_width;
			rh = image->rgb_height;
			gdk_imlib_render(image, rw, rh);
			pixmap = gdk_imlib_move_image(image);
			break;
		case MIRROR:
		{
			GdkPixmap *p1;
			GdkGC *gc;

			pixmap = gdk_pixmap_new(root_window, 2*image->rgb_width ,
				2*image->rgb_height , 
				gdk_visual_get_best_depth());

			gc = gdk_gc_new(root_window);
			gdk_gc_set_foreground(gc , &prop->background);

			gdk_draw_rectangle(pixmap , gc , TRUE , 0 , 0 , 
				2*image->rgb_width , 2*image->rgb_height);


			rw = image->rgb_width;
			rh = image->rgb_height;

			gdk_imlib_render(image, rw, rh);
			p1 = gdk_imlib_move_image(image);
			gdk_draw_pixmap(pixmap , gc , p1 ,
				0 , 0 , 0 , 0 , rw , rh);
			gdk_imlib_free_pixmap(p1);


			gdk_imlib_flip_image_vertical(image);
			gdk_imlib_render(image, rw, rh);
			p1 = gdk_imlib_move_image(image);
			gdk_draw_pixmap(pixmap , gc , p1 ,
				0 , 0 , 0 , rh , rw , rh);
			gdk_imlib_free_pixmap(p1);


			gdk_imlib_flip_image_horizontal(image);
			gdk_imlib_render(image, rw, rh);
			p1 = gdk_imlib_move_image(image);
			gdk_draw_pixmap(pixmap , gc , p1 ,
				0 , 0 , rw , rh , rw , rh);
			gdk_imlib_free_pixmap(p1);


			gdk_imlib_flip_image_vertical(image);
			gdk_imlib_render(image, rw, rh);
			p1 = gdk_imlib_move_image(image);
			gdk_draw_pixmap(pixmap , gc , p1 ,
				0 , 0 , rw , 0 , rw , rh);
			gdk_imlib_free_pixmap(p1);

			gdk_gc_unref(gc);

		}
			break;
		case CENTER:
		{
			GdkPixmap *p1;
			GdkGC *gc;

			pixmap = gdk_pixmap_new(root_window, rw , rh , 
				gdk_visual_get_best_depth());

			gc = gdk_gc_new(root_window);
			gdk_gc_set_foreground(gc , &prop->background);

			gdk_draw_rectangle(pixmap , gc , TRUE , 0 , 0 , 
				rw , rh);
			shade_pixmap(prop, pixmap , gc , rw , rh);

			gdk_imlib_render(image, image->rgb_width, image->rgb_height);
			p1 = gdk_imlib_move_image(image);
			gdk_draw_pixmap(pixmap , gc , p1 ,
				0 , 0 , 
				(rw - image->rgb_width) / 2 , 
				(rh - image->rgb_height) / 2 , 
				image->rgb_width , image->rgb_height);
			gdk_imlib_free_pixmap(p1);

			gdk_gc_unref(gc);
		}
			break;
		case MAXIMIZE:
			gdk_imlib_render(image, rw, rh);
			pixmap = gdk_imlib_move_image(image);
			break;
		case MAX_ASP_RATIO_CENTER:
		{
			GdkPixmap *p1;
			GdkGC *gc;
			gfloat ratio;
			guint pw , ph;

			pixmap = gdk_pixmap_new(root_window, rw , rh , 
				gdk_visual_get_best_depth());

			gc = gdk_gc_new(root_window);
			gdk_gc_set_foreground(gc , &prop->background);

			gdk_draw_rectangle(pixmap , gc , TRUE , 0 , 0 , 
				rw , rh);
			shade_pixmap(prop, pixmap , gc , rw , rh);

			ratio = MIN((gfloat)((rw * prop->max_size)/100) / (gfloat)image->rgb_width ,
				(gfloat)((rh * prop->max_size)/100) / (gfloat)image->rgb_height);

			ratio = MIN(prop->max_grow , ratio);

			pw = (guint)(ratio * image->rgb_width);
			ph = (guint)(ratio * image->rgb_height);

			gdk_imlib_render(image , pw , ph);
			p1 = gdk_imlib_move_image(image);

			gdk_draw_pixmap(pixmap , gc , p1 ,
				0 , 0 , 
				(rw - pw) / 2 , (rh - ph) / 2 , pw , ph);

			gdk_imlib_free_pixmap(p1);
			gdk_gc_unref(gc);
		}
			break;
	}

	if (!stop_changing)
	{
		if (have_setup) 
			while(gtk_events_pending()) gtk_main_iteration();

		gdk_window_set_back_pixmap(root_window, pixmap, FALSE);

		chbg_clear_window(root_window , prop->efect);
#ifdef HAVE_ESETROOT_SUPPORT
		if (!cfg.inwindow && !cfg.screensaver && 
			!cfg.xscreensaver && !stop_changing)
			set_pixmap_property(root_window,pixmap,rw,rh,prop);
#endif /* HAVE_ESETROOT_SUPPORT */
	}
	gdk_imlib_free_pixmap(pixmap);
	gdk_imlib_kill_image(image);

	gdk_flush();

	return 0;
}

static guint is_option(str , argc , argv)
gchar *str;
guint argc;
gchar **argv;
{
	guint i;
	for(i = 1; i < argc ; i++)
		if (!strcasecmp(str , argv[i])) return TRUE;

	return FALSE;
}

static int check_pattern(str)
char *str;
{
	GSList *ptr = cfg.pattern;

	if (!ptr) return TRUE;

	while(ptr)
	{
		if (!fnmatch((char *)ptr->data, str , FNM_PATHNAME))
			return TRUE;
		ptr = ptr->next;
	}
	return FALSE;
}

void recurse_dir()
{
	GSList *ptr = cfg.pics;
	GSList *pptr;
	struct stat estat;

	while(ptr)
	{
		pptr = ptr->next;
		if (!stat(((picentry *)ptr->data)->name , &estat))
		{
			if (S_ISDIR(estat.st_mode))
			{
				DIR *d = opendir(((picentry *)ptr->data)->name);
				struct dirent *dent;
				picentry *pe;

				if (d)
				{
					while((dent = readdir(d)))
					{
						if (!strcmp(dent->d_name , ".") ||
						     !strcmp(dent->d_name , ".."))
							continue;

						if (!check_pattern(dent->d_name))
							continue;

						pe = g_malloc(sizeof(picentry));
						pe->name = g_strconcat(((picentry *)ptr->data)->name , "/" , dent->d_name , NULL);
						pe->prop =  ((picentry *)ptr->data)->prop ?
							g_memdup(((picentry *)ptr->data)->prop , sizeof(propt)) : NULL;
						cfg.pics = g_slist_append(cfg.pics , pe);
						cfg.num_pics ++;
					}
					closedir(d);
					pptr = ptr->next;	
					cfg.pics = g_slist_remove_link(cfg.pics , ptr);
					cfg.num_pics --;
				}
			}
		}
		ptr = pptr;
	}
}

void init_locale_env()
{
	char *lang;
	char *lc_messages;
	char *lc_all;
	char *lc_ctype;
	char *l = NULL;

	lang = g_strdup(getenv("LANG"));
	lc_all = g_strdup(getenv("LC_ALL"));
	lc_messages = g_strdup(getenv("LC_MESSAGES"));
	lc_ctype = g_strdup(getenv("LC_CTYPE"));

	if (lc_all) unsetenv("LC_ALL");
	if (lang) unsetenv("LANG");
	if (lc_messages) unsetenv("LC_MESSAGES");
	unsetenv("LC_TIME");
	unsetenv("LC_NUMERIC");

	if (lc_messages) l = lc_messages;
	else if (lang) l = lang;
	else if (lc_all) l = lc_all;

	if (l) setenv("LC_MESSAGES" , l , TRUE);

	if (!lc_ctype)
	{
		if (lc_all) setenv("LC_CTYPE" , lc_all , TRUE);
		else if (lang) setenv("LC_CTYPE" , lang , TRUE);
	}

	g_free(lang);
	g_free(lc_messages);
	g_free(lc_all);
}

void run_changing_process()
{
	picentry *pe;
	GdkColor *actc;

	if (cfg.inwindow)
	{
		cfg.screensaver = FALSE;
		cfg.xscreensaver = FALSE;
		if (!cfg.windowid)
			init_window();
	}


	if (cfg.screensaver && !cfg.xscreensaver)
	{
		init_screensaver();
	}

	if (cfg.recurse)
	{
		recurse_dir();
	}

	if (!cfg.pics && cfg.cycle_blank)
	{
		while(!stop_changing)
		{
			srand(time(NULL));
			set_blank_screen( &cfg.properties);
			if (cfg.screensaver || cfg.inwindow || have_setup)
			{
				tid = gtk_timeout_add((guint)(cfg.properties.interval * (gfloat)60000) ,
					(GtkFunction) Switch , NULL);
				gtk_main();
			}
			else
				sleep((guint)(cfg.properties.interval * (gfloat)60));
		}
	}
	else
	{
	    while(!stop_changing && cfg.pics)
	    {
		GSList *ptr = cfg.pics;
		
		int picture_number=1;

		srand(time(NULL));
		if ( cfg.randomize ) {
			while (ptr) {
				ptr = ptr->next;
				picture_number++;
			}
			ptr = cfg.pics;
		}
		restart_loop = FALSE;
		while (!restart_loop && !stop_changing && ptr)
		{
			if (cfg.randomize)
			{
				GSList *r = cfg.pics;
				int i,l;
				l = (int)((float)picture_number*(float)rand()/(RAND_MAX+1.0));
				for ( i=0 ; i<l && r ; i++ ) {
					r = r->next;
				}
				ptr = r;

				if (!ptr) ptr = cfg.pics;
			}

			pe = (picentry *)ptr->data;
			actc = pe->prop ? &pe->prop->background : &cfg.properties.background;
			gdk_color_alloc(gdk_colormap_get_system() , actc);
			
			if (!set_root_bg(pe->name , pe->prop ? pe->prop : &cfg.properties))
			{
				if (cfg.num_pics > 1 && !stop_changing)
				{
					if (cfg.screensaver || cfg.inwindow || have_setup)
					{
						tid = gtk_timeout_add((guint)((pe->prop ? pe->prop->interval : 
							cfg.properties.interval) * (gfloat)60000) ,
							(GtkFunction) Switch , NULL);
						gtk_main();
					}
					else
						sleep((guint)((pe->prop ? pe->prop->interval : 
							cfg.properties.interval) * (gfloat)60));
				}
				if (!restart_loop)
					ptr = ptr->next;
			}
			else if (cfg.blank && !stop_changing)
			{
				set_blank_screen(pe->prop ? pe->prop : &cfg.properties);
				if (cfg.screensaver || cfg.inwindow || have_setup)
				{
					tid = gtk_timeout_add((guint)((pe->prop ? pe->prop->interval : 
						cfg.properties.interval) * (gfloat)60000) ,
						(GtkFunction) Switch , NULL);
					gtk_main();
				}
				else
					sleep((guint)((pe->prop ? pe->prop->interval : 
						cfg.properties.interval) * (gfloat)60));
				if (!restart_loop)
					ptr = ptr->next;
			}
			else if (!restart_loop && !stop_changing)
			{
				GSList *nx = ptr->next;

				printf(gettext("removing picture \"%s\" from list\n") , ((picentry *)ptr->data)->name);

				if (pe->prop) g_free(pe->prop);
				g_free(pe->name);
				g_free(pe);
				cfg.pics = g_slist_remove_link(cfg.pics , ptr);
				cfg.num_pics --;

				ptr = nx;
			}
			gdk_colormap_free_colors(gdk_colormap_get_system() ,
							actc , 1);
		}
		if (cfg.num_pics < 2) break;
	    }

	    if (cfg.num_pics)
	    {
		if (cfg.screensaver && !stop_changing)
		{
			gtk_main();
		}
		else if (!stop_changing)
			printf(gettext("only one picture available : changing not required\n"));
	    }
	    else
	    {
		if (cfg.blank)
			set_blank_screen(&cfg.properties);
		printf(gettext("unable to find any suitable picture\n"));
	    }
	}

	if (cfg.inwindow && !cfg.windowid)
		gdk_window_destroy(screensaver_window);

	if (!have_setup && gtk_main_level() > 0) gtk_main_quit();
	stop_changing = FALSE;
	if (tid) gtk_timeout_remove(tid);
	tid = 0;
}


gint main(argc , argv)
guint argc;
gchar **argv;
{
	char *p,pom[PATH_MAX];

	stop_changing = FALSE;

	init_locale_env();

#ifdef GETTEXT_NLS
        gtk_set_locale();
#ifdef NLS_DIR
	bindtextdomain(PACKAGE , NLS_DIR);
#endif
        textdomain(PACKAGE);
#endif
	gdk_init(&argc , &argv);
	gdk_rgb_init();

	cfg_default();

	if (!is_option("-scenario" , argc , argv))
	{
		p = g_get_home_dir();
		if (!p) p = "";
		sprintf(pom , "%s/.chbgrc" , p);
		if (!access(pom , R_OK))
			cfg_scenario(pom);
#ifdef DEFAULT_SYS_CHBG_RC
		else if (!access(DEFAULT_SYS_CHBG_RC , R_OK))
			cfg_scenario(DEFAULT_SYS_CHBG_RC);
#endif
	}

	if (cfg_cmdln(argc , argv))
		cfg_usage(argv[0]);

	if (cfg.scenario)
	{
		cfg_scenario(cfg.scenario);
	}

	if ((!cfg.pics && !cfg.blank) || cfg.setup)
	{
		gdk_imlib_init();
		have_setup = TRUE;
		run_setup(&argc , &argv);
	}
	else
	{
		if (cfg.windowid)
		{
			cfg.inwindow = TRUE;
		}
	
		if (cfg.inwindow)
		{
			cfg.screensaver = FALSE;
			cfg.xscreensaver = FALSE;
			if (cfg.windowid)
			{
				screensaver_window = gdk_window_foreign_new(cfg.windowid);
				if (!screensaver_window)
				{
					printf(gettext("Unable to find window id - %lx\n") , cfg.windowid);
				}
			}
		}

		if (cfg.screensaver && !cfg.xscreensaver)
		{
			gtk_init(&argc , &argv);
		}

		if (cfg.xscreensaver)
		{
			gtk_init(&argc , &argv);
			screensaver_window = xss_get_window();
			if (!screensaver_window)
			{
				printf("Unable to find xscreensaver window\n");
				return -1;
			}
		}

		gdk_imlib_init();

		run_changing_process();
	}

	return 0;
}

