#include "swserv.h"

#define THIS_CMD_NAME	"memory"
  
 
/*
 *      Print, refresh, or reload items in memory
 *      (not counting processes).
 */
int CmdMemory(int condescriptor, char *arg)
{
	int i, status;
        char sndbuf[CS_DATA_MAX_LEN];
        long total_mem,
             aux_mem,  
             connection_mem,
             objects_mem,   
             recycle_buf_mem,
             opm_mem,
             ocs_mem,
             schedual_mem;
        long con_object_num;
	xsw_object_struct *con_obj_ptr;


        /* Get connection's object number (assumed valid). */
        con_object_num = connection[condescriptor]->object_num;
	con_obj_ptr = xsw_object[con_object_num];


        /* Check if allowed to view memory. */
        if(con_obj_ptr->permission.uid > ACCESS_UID_MEM)
        {
            sprintf(sndbuf,
   "%s: Access level %i: Permission denied.",
                THIS_CMD_NAME, ACCESS_UID_MEM
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


        /* Calculate memory being used. */
        SWServGetMemoryStats(
            &total_mem,
            &aux_mem,
            &connection_mem,
            &objects_mem,
            &recycle_buf_mem,
            &opm_mem,  
            &ocs_mem,  
            &schedual_mem   
        );
             
             
        /* Print memory stats. */
        if((arg == NULL) ? 1 : (arg[0] == '\0'))
        {
            sprintf(sndbuf,
"-        total       con      objs    recbuf      opms      ocss scheduals"
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            sprintf(sndbuf,
"Mem:\
 %9ld\
 %9ld\
 %9ld\
 %9ld\
 %9ld\
 %9ld\
 %9ld",
                total_mem,
                connection_mem,
                objects_mem,
                recycle_buf_mem,
                opm_mem,
                ocs_mem,
                schedual_mem
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            
            sprintf(sndbuf,
"Ent:\
 %9ld\
 %9d\
 %9ld\
 %9d\
 %9d\
 %9d\
 %9d",   
        
                total_objects + total_connections + total_recycled_objects +
                total_opms + total_ocss,
            
                total_connections,
                total_objects,
                total_recycled_objects,
                total_opms,
                total_ocss,
                total_scheduals
            );
            NetSendLiveMessage(condescriptor, sndbuf);


            /* Print usage at end. */ 
            sprintf(
                sndbuf,
                "Usage: `%s [reload|refresh|reload_universe]'",
                THIS_CMD_NAME
            );
            NetSendLiveMessage(condescriptor, sndbuf);
 

            return(0);
        }

 
        /* ********************************************************** */

        /* Reset memory? */
        if(!strcasecmp(arg, "reset") ||
           !strcasecmp(arg, "reload")
	)
        {
            /* Permission check. */
            if(con_obj_ptr->permission.uid > ACCESS_UID_MEMOP)
            {
                sprintf(
		    sndbuf,
 "%s: Requires access level %i: Permission denied.",
		    THIS_CMD_NAME, ACCESS_UID_MEMOP
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Set master reset to 2 so that the configuration will
	     * be reloaded.  The universe database file will NOT be
	     * reloaded.
	     */
	    master_reset = 2;
        }
        /* Refresh objects in memory. */
        else if(!strcasecmp(arg, "refresh"))
        {
	    /* Permission check. */
            if(con_obj_ptr->permission.uid > ACCESS_UID_MEMOP)
            {
                sprintf(
                    sndbuf,
 "%s: Requires access level %i: Permission denied.",
                    THIS_CMD_NAME, ACCESS_UID_MEMOP
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

            /* Set master reset to 1 so that the memory will be
	     * refreshed.
	     */
	    master_reset = 1;
        }
        /* Reload input universe file. */
        else if(strpfx(arg, "reload_universe"))
        {
            /* Permission check. */
            if(con_obj_ptr->permission.uid > ACCESS_UID_MEMRELOADUNV)
            {
                sprintf(
                    sndbuf,   
 "%s: Requires access level %i: Permission denied.",
                    THIS_CMD_NAME, ACCESS_UID_MEMRELOADUNV
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Set master reset to 3 so that the universe database
	     * will be reloaded from the universe in file.
	     */
	    master_reset = 3;
        }
	/* Unsupported operation. */
	else
	{
	    sprintf(
		sndbuf,
		"%s: %s: Unsupported operation.",
		THIS_CMD_NAME, arg
	    );
	    NetSendLiveMessage(condescriptor, sndbuf);
	}


        return(0);
}

