//
// $Id: BLRockFloor_S.pov,v 1.1 1999/03/27 07:29:53 xblast Exp $
// $Log: BLRockFloor_S.pov,v $
// Revision 1.1  1999/03/27 07:29:53  xblast
// Initial revision
//
//
#include "BLGeneric.inc"

#declare weightPart1 =
intersection {
  superellipsoid {
    <0.33,0.33>
    matrix <1.00, 0.00, 0.00,
            0.33, 1.00, 0.50
	    0.00, 0.00, 1.00,
	    0.00, 0.00, 0.00>	     
  }
  plane { x,0.01}
  plane { z,0.01}
}

#declare weightPart2 =
intersection {
  superellipsoid {
    <0.33,0.33>
    matrix <1.00, 0.00, 0.00,
            0.50, 1.00, 0.33
	    0.00, 0.00, 1.00,
	    0.00, 0.00, 0.00>	     
  }
  plane { x,0.01}
  plane { z,0.01}
}


union {
  union {
    #declare winkel=0
    #while (winkel < 360)
      object {weightPart1 rotate y*winkel}
      object {weightPart2 rotate y*(winkel+90)}
      #declare winkel=winkel+180
    #end
    translate <0,1,0>
    scale <1.667,0.833,1.5>
    translate <0,0,-0.333>
    pigment {color Red}
    finish {myShiny}
  }
  torus {
    0.475, 0.175
    rotate x*90
    translate <0,1.583,-0.1667>
    pigment {color Green}
    finish {myShiny}
  }
  translate <-4,0,0>
}

plane {
  y, 0
  pigment {
    crackle 
    color_map {
      [0.0 color Red]   
      [1.0 color rgb <0.5,0,0> ]   
    }
    scale 0.667
    turbulence 0.33
  }
  normal {
    crackle 
    slope_map {
      [0.0 1.0] [1.0 0.0]
    }
    scale 0.667
    turbulence 0.33
  }
  finish {Dull}
}
