## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


#
# This files tries to wrap a limited subset of the Tkinter canvas
# into GTK / Gnome.
#

#
# Some background information:
#
#   - Each card is a canvas group consisting of a background and foreground
#     image. Turning a card raises the respective image within that group.
#
#   - Each stack is a canvas group consisting of cards (i.e. a group of groups)
#
#   - Cards change stacks, and are bound to the main canvas when dragging
#     around.
#


# imports
import os, sys, types
from gtk import *
from gnome.ui import GnomeCanvas, GnomeCanvasGroup
import GdkImlib

# toolkit imports
from tkutil import anchor_tk2gtk, loadImage, bind                   #bundle#


# /***********************************************************************
# // canvas items
# //
# // My first (obvious) approach was to subclass the GnomeCanvas*
# // classes, but this didn't work at all...
# //
# // Now I've resorted to delegation, but what are the Gnome canvas item
# // classes for then ?
# ************************************************************************/

class _CanvasItem:
    def __init__(self, canvas):
        self.canvas = canvas
    def addtag(self, group):
        assert isinstance(group._item, GnomeCanvasGroup)
        self._item.reparent(group._item)
    def bind(self, sequence, func, add=None):
        bind(self._item, sequence, func, add)
    def dtag(self, group):
        assert isinstance(group._item, GnomeCanvasGroup)
        self._item.reparent(self.canvas.root())
    def delete(self):
        if self._item is not None:
            self._item.destroy()
            self._item = None
    def hide(self):
        self._item.hide()
    def lower(self, positions=None):
        ##print "lower", self._item, positions
        if positions is None:
            self._item.lower_to_bottom()
        else:
            assert type(positions) == types.IntType and positions > 0
            self._item.lower(positions)
    def move(self, x, y):
        self._item.move(x, y)
    def show(self):
        self._item.show()
    def tkraise(self, positions=None):
        ##print "tkraise", self._item, positions
        if positions is None:
            self._item.raise_to_top()
        else:
            assert type(positions) == types.IntType and positions > 0
            self._item.raise_(positions)


class MfxCanvasGroup(_CanvasItem):
    def __init__(self, canvas):
        _CanvasItem.__init__(self, canvas)
        self._item = canvas.root().add('group', x=0, y=0)



class MfxCanvasImage(_CanvasItem):
    def __init__(self, canvas, x, y, image, anchor=ANCHOR_NW):
        _CanvasItem.__init__(self, canvas)
        im = image.im
        assert isinstance(im, GdkImlib.Image)
        anchor = anchor_tk2gtk(anchor)
        self._item = canvas.root().add('image', x=x, y=y,
                                       width=image.width(), height=image.height(),
                                       image=im._im, anchor=anchor)

    def config(self, image):
        assert isinstance(image.im, GdkImlib.Image)
        self._item.set(image=image.im._im)


class MfxCanvasLine(_CanvasItem):
    def __init__(self, canvas, x1, y1, x2, y2, width, fill, arrow, arrowshape):
        _CanvasItem.__init__(self, canvas)
        # FIXME
        self._item = None


class MfxCanvasRectangle(_CanvasItem):
    def __init__(self, canvas, x1, y1, x2, y2, width, fill, outline):
        self._item = canvas.root().add('rect', x1=x1, y1=y1, x2=x2, y2=y2,
                                       width_pixels=width, outline_color=outline)
        if fill is not None:
            self._item.set(fill_color=fill)


class MfxCanvasText(_CanvasItem):
    def __init__(self, canvas, x, y, anchor=ANCHOR_NW, **kw):
        anchor = anchor_tk2gtk(anchor)
        self._item = canvas.root().add('text', x=x, y=y, anchor=anchor)
        if not kw.has_key('fill'):
            kw['fill'] = canvas._text_color
        for k, v in kw.items():
            self[k] = v
        self.text_format = None
        canvas._text_items.append(self)

    def __setitem__(self, key, value):
        if key == 'fill':
            self._item.set(fill_color=value)
        elif key == 'font':
            self._item.set(font=value)
        elif key == 'text':
            self._item.set(text=value)
        else:
            raise AttributeError, key

    def __getitem__(self, key):
        if key == 'text':
            # FIXME
            return ""
        else:
            raise AttributeError, key
    cget = __getitem__


# /***********************************************************************
# // canvas
# ************************************************************************/

class MfxCanvas(GnomeCanvas):
    def __init__(self, top, bg=None, highlightthickness=0):
        # Tkinter compat
        self.items = {}
        # private
        self.__tileimage = None
        self.__tiles = []
        # friend MfxCanvasText
        self._text_color = '#000000'
        self._text_items = []
        #
        ##GdkImlib.push_visual()
        GnomeCanvas.__init__(self)
        self.style = self.get_style().copy()
        if bg is not None:
            c = self.get_colormap().alloc(bg)
            self.style.bg[STATE_NORMAL] = c
        self.set_style(self.style)
        ##GdkImlib.pop_visual()
        self.set_scroll_region(0, 0, screen_width(), screen_height())
        top.vbox.pack_start(self)

    def __setattr__(self, name, value):
        self.__dict__[name] = value

    def bind(self, sequence=None, func=None, add=None):
        assert add is None
        # FIXME
        print "TkCanvas bind:", sequence
        return

    def cget(self, attr):
        if attr == 'cursor':
            # FIXME
            return GDK.LEFT_PTR
            return self.get_window().get_cursor(v)
        print "TkCanvas cget:", attr
        raise AttributeError, attr

    def configure(self, **kw):
        height, width = -1, -1
        for k, v in kw.items():
            if k == "background" or k == "bg":
                c = self.get_colormap().alloc(v)
                self.style.bg[STATE_NORMAL] = c
                self.set_style(self.style)
                self.queue_draw()
            elif k == "cursor":
                w = self.get_window()
                if w:
                    w.set_cursor(cursor_new(v))
            elif k == "height":
                height = v
            elif k == "width":
                width = v
            else:
                print "TkCanvas", k, v
                raise AttributeError, k
        if height > 0 and width > 0:
            self.set_usize(width, height)
            #self.queue_draw()
            #self.queue_resize()
            #self.show()
            #pass

    config = configure

    # PySol extension
    # delete all CanvasItems but keep the background tiles
    def deleteItems(self):
        ## FIXME
        pass

    # PySol extension
    def findCard(self, stack, event):
        # FIXME
        ##w = self.get_item_at(event.x, event.y)
        ##print w
        return stack._findCardXY(event.x, event.y)

    def pack(self, **kw):
        self.show()

    # PySol extension
    def setTextColor(self, color):
        if self._text_color != color:
            self._text_color = color
            for item in self._text_items:
                item.set(fill_color=_self.text_color)

    # PySol extension - set a tiled background image
    ### FIXME: should use style.bg_pixmap ????
    def setTile(self, image):
        for item in self.__tiles:
            item.destroy()
        self.__tiles = []
        if type(image) == types.StringType:
            image = loadImage(image)
        # must keep a reference to the image, otherwise Python will
        # garbage collect it...
        self.__tileimage = image
        if image is None:
            return
        iw, ih = image.width(), image.height()
        sw, sh = screen_width(), screen_height()
        for x in range(0, sw - 1, iw):
            for y in range(0, sh - 1, ih):
                item = self.root().add('image', x=x, y=y,
                                       width=iw, height=ih,
                                       image=image.im._im, anchor=ANCHOR_NW)
                item.lower_to_bottom()
                self.__tiles.append(item)

    def update_idletasks(self):
        self.update_now()

