/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Animation.h"
#include "../util/debug.h"
#include "../util/Integer.h"
#include "../util/File.h"
#include "../util/util.h"

//--------------------------------------------------------------------------------------------------------------------------------

template class Collection<Animation>;
template class SCollection<Animation>;

//--------------------------------------------------------------------------------------------------------------------------------

Animation::Animation(int _space, int _delta)
 : SCollection<Sprite>(_space, _delta)
{
 currentFrame = 0;
 advanceCounter = 0;
 speed = 1;
}

Animation::~Animation()
{
}

//--------------------------------------------------------------------------------------------------------------------------------

void Animation::advance(int i)
{
 assert(speed > 0);
 advanceCounter += i;
 (currentFrame += (advanceCounter / speed)) %= length();
 advanceCounter %= speed;
}

void Animation::reset()
{
 currentFrame = 0;
 advanceCounter = 0;
}

//--------------------------------------------------------------------------------------------------------------------------------

void Animation::add(Sprite* object)
{
 if(length() == 0) pZ = object->size();
 else if(object->size() != pZ) object->size(pZ);
 SCollection<Sprite>::add(object);
}

//--------------------------------------------------------------------------------------------------------------------------------

bool Animation::read(File& f)
{
 if(!f.read(speed)) return false;
 if(!SCollection<Sprite>::read(f)) return false;
 VPRINTF("<anim> Animation length=%d speed=%d read\n", length(), speed);
 if(length() > 0) pZ = at(0)->size();
 if(length() > 1) for(int i=0; i<length(); i++) if(at(i)->size() != pZ)
  { delAll(); pZ = Point(0, 0); setError("size inconsistency"); return false; }
 reset();
 return true;
}

bool Animation::write(File& f)
{
 if(!f.write(speed)) return false;
 if(!SCollection<Sprite>::write(f)) return false;
 return true;
}

//--------------------------------------------------------------------------------------------------------------------------------

Animation* Animation::create(File& f)
{
 Animation* a = new Animation;
 if(!a->read(f)) { delete a; return NULL; }
 return a;
}

//--------------------------------------------------------------------------------------------------------------------------------
