/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef ENGINE_ICS_H
#define ENGINE_ICS_H

#include <stdarg.h>
#include <stdio.h>

struct engine_ics { 
	gchar *user;
	gchar *pass;
	gboolean loggedin;
	int game;
};

struct engine * engine_ics_new(char *arg, char *user, char *pass, char *port, char *telnetprogram);
char *engine_ics_get_user(struct engine *e);
void engine_ics_set_user(struct engine *e, char *user);
char *engine_ics_get_pass(struct engine *e);
void engine_ics_set_pass(struct engine *e, char *pass);
gboolean engine_ics_is_loggedin(struct engine *e);
void engine_ics_set_loggedin(struct engine *e, gboolean li);
int engine_ics_get_game(struct engine *e);
void engine_ics_set_game(struct engine *e, int g);
int engine_ics_input(char *buf, int max);
void engine_ics_update_board(char *boardstring);
void engine_ics_cb( gpointer data, gint source, GdkInputCondition condition);

#endif
