/*
  termAvr.C

  Terminal Access to AVR mpu
  Uros Platise (c) 1997
*/

#include <iostream.h>
#include <stdio.h>
#include "AtmelTerm.h"

void TAtmelTerm::Run () {
  enableAvr ();
  if (isDeviceLocked ()) {
    string q;
    cout << "Do you want to clear it and enter normal mode now (enter y for yes): "; cin>>q;
    if (q=="y") { chipErase (); }
    else { return; }
  }
  cout << "Entering the AVR Terminal. ?-help, q-quit.\n";
  string cmd;
  unsigned int flash_addr = 0;
  unsigned int eeprom_addr = 0;
  do {
    try {
      cout << "avr>"; cin >> cmd;
      if (cmd=="?") {
	cout << "AVR Terminal supports the following commands:\n"
	  "ul fileName[%segs] - uploads data from Micro Output File\n"
	  "vf fileName[%segs] - compare (verify) file with memory\n"
	  "dl fileName[%segs] - downloads data to Micro Output File\n"
	  "ce                 - perform chip erase option\n"
	  "re addr            - read a byte from eeprom\n"
	  "we addr byte       - write 'byte' to eeprom at address 'addr'\n"
	  "rf addr            - read a word from flash memory\n"
	  "wf addr byte       - write 'byte' to flash memory\n"
	  "de addr            - dump eeprom starting at address 'addr'\n"
	  ".                  - continue eeprom dump\n"
	  "df addr            - dump flash memory starting at address 'addr'\n"
	  ",                  - continue flash dump\n"
	  "rsb                - read lock and fuse bits\n"
	  "wlb wr|rdwr        - write lock bits (wr=programming,rd=reading)\n"
	  "\n"
	  "To argument fileName segment names may be added seperated by\n"
	  "comas. An example: 'ul a.out%flash' will upload only flash segments.\n"
	  "'addr' and 'byte' are shown and must be entered in hex format.\n"
	  "Written by Uros Platise (c) 1997, uros.platise@fov.uni-mb.si\n";
      }
      else if (cmd=="ul") {
	char inputFileName [64]; scanf ("%s", inputFileName);
	try { 
	  TAout inAout (inputFileName, "rt");
	  upload (&inAout); 
	}
	catch (Error_Device& errDev) { errDev.print (); }
	catch (Error_C) { perror ("Error"); }
      }
      else if (cmd=="vf") {
	char inputFileName [64]; scanf ("%s", inputFileName);
	try { 
	  TAout inAout (inputFileName, "rt");
	  upload (&inAout, true); 
	}
	catch (Error_Device& errDev) { errDev.print (); }
	catch (Error_C) { perror ("Error"); }
      }
      else if (cmd=="dl") {
	char outputFileName [64]; scanf ("%s", outputFileName);
	try { 
	  TAout outAout (outputFileName, "wt");
	  download (&outAout); 
	}
	catch (Error_Device& errDev) { errDev.print (); }
	catch (Error_C) { perror ("Error"); }
      }
      else if (cmd=="ce") { 
	chipErase ();
      }
      else if (cmd=="rsb") {
	unsigned char byte = readLockBits ();
	printf ("Lock and Fuse bits status: %.2x\n", byte );
      }
      else if (cmd=="wlb") {
	string mode; cin >> mode;
	if (mode=="wr") { writeLockBits (lckPrg);
	} else if (mode=="rdwr") { writeLockBits (lckPrgRd); 
	} else { cout << "Invalid parameter: " << mode << '\n'; }
      }
      else if (cmd=="re") {
	unsigned int addr; scanf ("%x", &addr);
	printf ("eeprom: $%.2x\n", readEEPROM (addr));
      }
      else if (cmd=="we") {
	unsigned int addr, byte;
	scanf ("%x%x", &addr, &byte);
	writeEEPROM (addr, (unsigned char)byte);
      }
      else if (cmd=="rf") {
	unsigned int addr; scanf ("%x", &addr);
	printf ( "flash: $%.2x\n", readFLASH (addr));
      }
      else if (cmd=="wf") {
	unsigned int addr, byte;
	scanf ("%x%x", &addr, &byte);
	writeFLASH (addr, (unsigned char)byte);
      }
      else if (cmd=="de") {
	scanf ("%x", &eeprom_addr);
	goto show_eeprom;
      }
      else if (cmd==".") {
show_eeprom:
	int i,l=0;
	while (l<4) {
	  printf ("e2 $%.2x: ", eeprom_addr); 
	  for (i=0; i<0x8; eeprom_addr++,i++) 
	    printf ("%.2x ", readEEPROM(eeprom_addr));
	  cout << '\n';
	  l++;
	}  
      }
      else if (cmd=="df") {
	scanf ("%x", &flash_addr);
	goto show_flash;
      }
      else if (cmd==",") {
show_flash:
	int i,l=0;
	while (l<4) {
	  printf ("fh $%.3x: ", flash_addr);
	  for (i=0; i<0x8; flash_addr++,i++)
	    printf ("%.2x ", readFLASH (flash_addr));
	  cout << '\n';
	  l++;
	}
      } else cout << "Ouch.\n";
    } catch (Error_MemoryRange) { 
      printf ("Out of memory range!\n");
    }
  } while (cmd!="q");
}
