#include "ObjectBase.hh"
#include "SourceData.hh"
#include "SourceInfo.hh"

SourceId_t 
SourceData::getSourceId() const {
  return sourceId;
}

void 
SourceData::setSourceId(SourceId_t myId) {
  sourceId = myId;
}

VHDLType* 
SourceData::getData() const {
  return data;
}

SourceData*
SourceData::getDriver(const SourceId_t id) const {
  if ( id == sourceId ){
    return (SourceData *) this;
  } else {
    return NULL;
  }
}


SourceData*
SourceData::getDriveratIndex(int) const {
    return (SourceData *)this;
}

void 
SourceData::setData(VHDLType *myData) {
  data = myData;
}

bool
SourceData::_is_child_present(SourceId_t myId) {
  return INT_TO_BOOL(sourceId == myId);
}

bool
SourceData::_is_anonymous_driver() {
  if (sourceId == ANONYMOUS_PROCESS_ID) {
    return true;
  }

  return false;
}

void 
SourceData::updateData(const VHDLData &myData) {
  connected = true;
  data->getObject()->updateVal(myData);
}

void 
SourceData::updateData(const VHDLType &myData) {
  connected = true;
  *data = myData;
}

int 
SourceData::addChild(VHDLType *myData, SourceId_t myId) {
  data = myData;
  sourceId = myId;
  if ((parent != NULL) && (sourceId != ANONYMOUS_PROCESS_ID)) {
    parent->addToTable(this);
  }

  return 1;
}

int 
SourceData::addChild(SourceBase*) {
  cerr << "SourceData::addChild(SourceBase*) should never be called!!" << endl;
  abort();
  return 0;
}

void 
SourceData::print(ostream& os) const {
  os << "Source(" << sourceId << ") = ";
  data->print(os);
  os << endl;
}

VHDLType*
SourceData::resolve(VHDLKernelBase*, SigType) {
  //This is where the difference between a composite resolved signal 
  //resolution and resolution of composite signal of resolved subtype lies
  if(getData()->getObject()->getParentCompositeType() == NULL) {
    return getData();
  }
  else {
    return getData()->getObject()->getParentCompositeType();
  }
}
