#ifndef ACCESSVARIABLE_CC
#define ACCESSVARIABLE_CC

template <class Type>
inline void 
AccessVariable<Type>::print(ostream& os) const {
  os << "AccessVariable of type "
    << variableType << ":\n  ";
  os << "dataLength = " << dataLength << " ";
  os << "curpos = " << curPos << " ";
  os << "value: ";
  for (register int i = 0; i < dataLength; i++) {
    os << val[i];
  }
}


template <class Type>
inline
AccessVariable<Type>::AccessVariable() {
  init();
}


template <class Type>
inline
AccessVariable<Type>::AccessVariable(char* newname) : AccessVarBase(newname) {
  init();
}


template <class Type>
inline
void AccessVariable<Type>::init() { 
  name = NULL;
  variableType = ACCESS;
  dataLength = 0;
  curPos = 0;
  val = NULL;
}


inline
AccessVariable<char*>::AccessVariable(const AccessVariable<char*>& v) 
: AccessVarBase(v.name) {

  dataLength = v.dataLength;
  curPos = v.curPos;
  if (dataLength > 0) {
    val = new char[dataLength];
    memcpy(val, v.val, dataLength);
  }
  else {
    val = NULL;
  }
}


inline AccessVariable<char*>&
AccessVariable<char*>::operator=(const AccessVariable<char*>& v) {
  if (dataLength > 0) {
    delete [] val;
  }
  dataLength = v.dataLength;
  curPos = v.curPos;
  if (dataLength > 0) {
    val = new char[dataLength];
    memcpy(val, v.val, dataLength);
  }
  else {
    val = NULL;
  }
  return *this;
}

// The argument string MUST be a NULL terminated string.
inline AccessVariable<char*>&
AccessVariable<char*>::operator=(const char* string) {
  if (strlen(string) > 0) {
    delete [] val;
  }
  dataLength = strlen(string);
  curPos = 0;
  if (dataLength > 0) {
    val = new char[dataLength];
    memcpy(val, string, dataLength);
  } else {
    val = NULL;
  }
  return *this;
}
#endif
