
#ifndef SWITCH_FILE_HH
#define SWITCH_FILE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.
// All rights reserved. 

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Author: Dale E. Martin          dmartin@ece.uc.edu

//---------------------------------------------------------------------------
//
// $Id: switch_file.hh,v 1.4 1999/07/23 21:08:29 dmartin Exp $
//
//---------------------------------------------------------------------------

#include <fstream.h>
#include "savant.hh"
#include "hash_table.hh"
#include <string.h>

class switch_file : public ofstream {

public:

  switch_file();

  // Pass in the file descriptor that you'd like to initizalize it with.
  switch_file( int );

  ~switch_file();

  void set_file( char *, char* = NULL, bool = false );
  void set_file( bool, char *, char* = NULL, bool = false );
  char *get_file_name();

  void reset();

  bool get_file_output(){ return file_output; }
  void set_file_output( bool new_file_output ){ file_output = new_file_output; }

  void set_create_via_temporaries(bool value) {
    create_via_temporaries = value;
  }
  
private:
  bool file_output;

  char *file_name;

  void move_temporary_files();
  void move_temporary_files(const char *);

  bool first_time( char * );

  // This is the definition of the class that the has table uses
  class file_record {
  public:
    file_record(){
      been_used = false;
    };

    ~file_record(){
      delete file_name;
    }

    void set_used(){
      been_used = true;
    }

    bool get_used(){
      return been_used;
    }
    
    void set_key( char *key_val, unsigned int length ){
      ASSERT( length == strlen( key_val ) );
      file_name = strdup(key_val);
    }

    int test_key( char *key_val, unsigned int length ){
      ASSERT( length == strlen( key_val ) );
      return strcmp( key_val, file_name );
    }

    char* get_file_name() const {
      return file_name;
    }
    
  private:
    char *file_name;
    bool been_used;
  };

  void move_temporary_files(dl_list<file_record>*);
  bool create_via_temporaries;
  hash_table<file_record> file_table;
};

#endif


