// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_WaveformList.cc,v 1.2 1999/03/09 20:57:14 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_WaveformList.hh"
#include "IIR_WaveformElement.hh"

IIRScram_WaveformList::~IIRScram_WaveformList() {}


void 
IIRScram_WaveformList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_WaveformElement* element = first();
  for(; element != NULL; ) {
    element->_publish_vhdl(_vhdl_out);
    element = successor(element);
    if(element != NULL) {
      _vhdl_out << ", ";
    }
  }
}


void
IIRScram_WaveformList::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  IIR_WaveformElement* element = first();
  for(; element != NULL; ) {
    element->_get_list_of_input_signals(list);
    element = successor(element);
  }
}


void
IIRScram_WaveformList::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  IIR_WaveformElement* element = first();
  for(; element != NULL; ) {
    element->_build_sensitivity_list(sensitivity_list);
    element = successor(element);
  }  
}


