// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ValueAttribute.cc,v 1.3 1999/09/29 13:55:34 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ValueAttribute.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_Declaration.hh"
#include "StandardPackage.hh"
#include "set.hh"
#include "error_func.hh"
#include <strstream.h>

IIRScram_ValueAttribute::~IIRScram_ValueAttribute() {}

void 
IIRScram_ValueAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL && get_suffix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'VALUE ";
  _vhdl_out << "(";
  get_suffix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ") ";
}


void 
IIRScram_ValueAttribute::_publish_cc() {
  _publish_cc_type_attribute("VALUE", TRUE);
}

IIR_TextLiteral *
IIRScram_ValueAttribute::_build_attribute_name(){
  char *name = "value";

  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_ValueAttribute::_get_subtype(){
  return _get_prefix_subtype();
}

void 
IIRScram_ValueAttribute::_resolve_suffix_special(){
  // Suffix must be an expression of type string

  if( get_suffix() != NULL && get_suffix()->_is_resolved() == FALSE ){

    ASSERT( get_prefix()->_is_resolved() == TRUE );

    set<IIR_TypeDefinition> *suffix_types = get_suffix()->_get_rval_set();
    IIR_TypeDefinition *string_rval = StandardPackage::string_type;

    IIR_TypeDefinition *current_type = suffix_types->get_element();
    while( current_type != NULL ){
      if( current_type == string_rval ){
	break;
      }
    
      current_type = suffix_types->get_next_element();
    }

    if( current_type != NULL ){
      set_suffix( get_suffix()->_semantic_transform( current_type ) );
      get_suffix()->_type_check( current_type );
      set_suffix( get_suffix()->_rval_to_decl( current_type ) );
    }
    else{
      ostrstream err;
      err << "|" << *get_suffix() << "| is not a valid suffix for |" << *this << "|.";
      err << " The suffix must be a locally static expression of type string." << ends;
    
      report_error( this, err );
    }
  }  
}
