#ifndef IIRSCRAM_USE_CLAUSE_HH
#define IIRSCRAM_USE_CLAUSE_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_UseClause.hh,v 1.4 1999/10/28 03:24:12 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_UseClause.hh"

class IIR_List;
class symbol_table;

class IIRScram_UseClause : public IIRBase_UseClause {
public:
  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);

  void _publish_cc_package_name();
  void _publish_cc_headers();

  void _type_check();

  IIR_Boolean _is_specification(){ return true; }
  IIR_Declaration* _get_package_declaration();
  void _make_interface_visible( symbol_table * );
  virtual IIR *_clone();

protected:
  IIRScram_UseClause();
  virtual ~IIRScram_UseClause() = 0;
    
private:
};
#endif







