#ifndef IIRSCRAM_TYPE_DECLARATION_HH
#define IIRSCRAM_TYPE_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TypeDeclaration.hh,v 1.4 1999/10/28 03:24:11 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_TypeDeclaration.hh"

template <class type> class set;
class IIR_List;

class IIRScram_TypeDeclaration : public IIRBase_TypeDeclaration {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_range(ostream &);
  // c++ code generation methods
  void _publish_cc();
  void _publish_cc_headers();
  IIR_Boolean _is_access_type();
  void _publish_cc_decl();
  void _publish_cc_type_name();
  void _publish_cc_universal_type();
  void _publish_cc_range();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();

  IIR_Boolean _attach_attribute( IIR_AttributeSpecification * );
  IIR_AttributeSpecificationList* _get_attribute_specification_list(){return &attributes;}


  IIR_TypeDefinition *_get_subtype();

  IIR_Boolean _is_iir_type_declaration(){ return TRUE; }
  IIR_Boolean _is_incomplete_type_declaration();
  IIR_Boolean _designates_incomplete_type();
  IIR_Boolean _can_be_in_same_region( IIR_Declaration * );

  IIR_Boolean _is_type(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }

  IIR_Boolean _is_scalar_type();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_kernel_type();
  IIR_Int32 _get_num_indexes();
  declaration_type _get_type();

  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  set<IIR_Declaration> *_find_declarations( IIR_TextLiteral * );

  void _add_decl_into_cgen_symbol_table();

  // The following methods apply to incomplete type declarations.  After
  // the parser has found the definition of an incomplete type, these methods
  // can be called on the incomplete type to get the full definition.
  IIR_TypeDefinition *_get_fully_defined_type(){
    return _fully_defined_type;
  }

  void _set_fully_defined_type( IIR_TypeDefinition *my_real_type ){
    _fully_defined_type = my_real_type;
  }

  void _come_into_scope( symbol_table *sym_tab );
  void _come_out_of_scope( symbol_table *sym_tab );

  virtual IIR *_clone();

protected:
  IIRScram_TypeDeclaration(){
    _fully_defined_type = NULL;
  }

  virtual ~IIRScram_TypeDeclaration() = 0;
    
private:
  IIR_TypeDefinition *_fully_defined_type;
};
#endif
