#ifndef IIRSCRAM_TRANSACTION_ATTRIBUTE_HH
#define IIRSCRAM_TRANSACTION_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TransactionAttribute.hh,v 1.2 1999/03/09 20:56:55 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_TransactionAttribute.hh"


class IIRScram_TransactionAttribute : public IIRBase_TransactionAttribute {
public:
  void _publish_vhdl(ostream &);
  IIR_Boolean _is_signal() { return TRUE; }
  IIR_TextLiteral *_build_attribute_name();
  IIR_TypeDefinition *_get_subtype();

  IIR_Declaration *_get_implicit_declaration( char *decl_name, IIR_TypeDefinition *decl_type );

  void _publish_cc();
  void _publish_cc_necessary_decl_in_state();
  void _publish_cc_name_in_caps();
  void _publish_cc_attrib_type();
  void _publish_cc_necessary_decl_init();
  void _publish_cc_init_val();
  void _publish_cc_elaborate();
  void _publish_cc_sigtype();
  void _publish_cc_type_cast();
  void _publish_cc_state_object_init();
  void _publish_cc_necessary_copying();
  void _publish_cc_read_or_write(const char *, const char *);
  
  IIR_Boolean _is_transaction_attribute() { return TRUE; }
  IIR_Boolean _is_signal_attribute(){ return TRUE; }

protected:
  IIRScram_TransactionAttribute() {};
  virtual ~IIRScram_TransactionAttribute() = 0;
    
private:
};
#endif
