#ifndef IIRSCRAM_SUBTYPE_DECLARATION_HH
#define IIRSCRAM_SUBTYPE_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SubtypeDeclaration.hh,v 1.4 1999/10/28 03:24:10 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_SubtypeDeclaration.hh"

class IIR_TypeDefinition;
class IIR_List ;
class IIR_AttributeSpecificationList;

class IIRScram_SubtypeDeclaration : public IIRBase_SubtypeDeclaration {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_range(ostream &);
  declaration_type _get_type();

  IIR_TypeDefinition *_get_subtype();
  IIR_AttributeSpecificationList* _get_attribute_specification_list();
  IIR_Boolean _is_type(){ return TRUE; }

  IIR_Boolean _is_subtype_decl() { return TRUE; }
  IIR_Boolean _is_iir_subtype_declaration(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }

  void _publish_cc();
  void _publish_cc_type_name();
  void _publish_cc_headers();
  void _publish_cc_decl();
  void _publish_cc_universal_type();
  void _publish_cc_range();
  virtual void _publish_cc_type_info();
  virtual void _publish_cc_extern_type_info();
  virtual IIR *_clone();

  IIR_Boolean _is_scalar_type();
  IIR_Boolean _is_array_type();
  IIR_Int32 _get_num_indexes();
  IIR_Boolean _is_resolved_type();
  IIR_Boolean _is_kernel_type();

protected:
  IIRScram_SubtypeDeclaration() {}
  virtual ~IIRScram_SubtypeDeclaration() = 0;
    
private:
};
#endif

